/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.devlogin;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import net.covers1624.devlogin.DevLogin;
import net.covers1624.devlogin.data.Account;
import net.covers1624.devlogin.data.AuthenticationResponse;
import net.covers1624.devlogin.data.DeviceAuthorizationResponse;
import net.covers1624.devlogin.data.MicrosoftApiError;
import net.covers1624.devlogin.data.MinecraftApiError;
import net.covers1624.devlogin.data.MinecraftAuthResponse;
import net.covers1624.devlogin.data.MinecraftProfile;
import net.covers1624.devlogin.data.XBLAuthenticationResponse;
import net.covers1624.devlogin.data.XSTSAuthenticationResponse;
import net.covers1624.devlogin.data.XboxApiError;
import net.covers1624.devlogin.http.HttpEngine;
import net.covers1624.devlogin.http.HttpResponse;
import net.covers1624.devlogin.util.ColUtils;
import org.jetbrains.annotations.Nullable;

public class MicrosoftOAuth {
    public static final String CLIENT_ID = "170105bd-9573-4222-b09c-6f24c3b77cd8";
    public static final String TENANT = "consumers";
    public static final String DEVICE_CODE_URL = "https://login.microsoftonline.com/consumers/oauth2/v2.0/devicecode";
    public static final String TOKEN_URL = "https://login.microsoftonline.com/consumers/oauth2/v2.0/token";
    public static final String XBL_AUTH_URL = "https://user.auth.xboxlive.com/user/authenticate";
    public static final String XSTS_AUTH_URL = "https://xsts.auth.xboxlive.com/xsts/authorize";
    public static final String MINECRAFT_XBOX_LOGIN_URL = "https://api.minecraftservices.com/authentication/login_with_xbox";
    public static final String MINECRAFT_PROFILE_URL = "https://api.minecraftservices.com/minecraft/profile";

    public static AuthenticationResponse deviceAuth(HttpEngine engine) throws IOException {
        DeviceAuthorizationResponse deviceAuth = MicrosoftOAuth.startDeviceAuth(engine);
        System.out.println("[DevLogin]: " + deviceAuth.message);
        long expires = System.currentTimeMillis() / 1000L + (long)deviceAuth.expiresIn;
        while (System.currentTimeMillis() / 1000L < expires) {
            AuthenticationResponse resp;
            try {
                Thread.sleep((long)deviceAuth.interval * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((resp = MicrosoftOAuth.checkDeviceAuth(engine, deviceAuth)) == null) continue;
            System.out.println("[DevLogin] Device code validated!");
            return resp;
        }
        System.err.println("Device code flow failed, code flow not completed within " + deviceAuth.expiresIn + " seconds.");
        System.exit(1);
        return null;
    }

    private static DeviceAuthorizationResponse startDeviceAuth(HttpEngine engine) throws IOException {
        return (DeviceAuthorizationResponse)engine.postForm(DEVICE_CODE_URL, ColUtils.mapOf("client_id", CLIENT_ID, "scope", "XboxLive.signin offline_access")).fromJson(DevLogin.GSON, (Type)((Object)DeviceAuthorizationResponse.class));
    }

    @Nullable
    private static AuthenticationResponse checkDeviceAuth(HttpEngine engine, DeviceAuthorizationResponse deviceAuth) throws IOException {
        HttpResponse response = engine.postForm(TOKEN_URL, ColUtils.mapOf("grant_type", "urn:ietf:params:oauth:grant-type:device_code", "client_id", CLIENT_ID, "device_code", deviceAuth.deviceCode));
        if (response.code != 200) {
            MicrosoftApiError error = (MicrosoftApiError)response.fromJson(DevLogin.GSON, (Type)((Object)MicrosoftApiError.class));
            if (error.error.equals("authorization_pending")) {
                return null;
            }
            throw new RuntimeException("Device flow failed: " + error.errorDescription);
        }
        return (AuthenticationResponse)response.fromJson(DevLogin.GSON, (Type)((Object)AuthenticationResponse.class));
    }

    public static AuthenticationResponse refreshMicrosoftAuth(HttpEngine engine, Account.MSTokens tokens) throws IOException {
        HttpResponse resp = engine.postForm(TOKEN_URL, ColUtils.mapOf("grant_type", "refresh_token", "client_id", CLIENT_ID, "scope", "XboxLive.signin offline_access", "refresh_token", tokens.refreshToken));
        if (resp.code != 200) {
            MicrosoftApiError error = (MicrosoftApiError)resp.fromJson(DevLogin.GSON, (Type)((Object)MicrosoftApiError.class));
            if (error.error.equals("invalid_grant")) {
                throw new GrantExpiredException(error);
            }
            throw new RuntimeException("Failed to refresh Microsoft Token: " + error.errorDescription);
        }
        return (AuthenticationResponse)resp.fromJson(DevLogin.GSON, (Type)((Object)AuthenticationResponse.class));
    }

    public static Account loginToAccount(HttpEngine engine, AuthenticationResponse msAuth) throws IOException {
        System.out.println("[DevLogin] Logging into account..");
        XBLAuthenticationResponse xblAuth = MicrosoftOAuth.authenticateWithXBL(engine, msAuth.accessToken);
        XSTSAuthenticationResponse xstsAuth = MicrosoftOAuth.authenticateWithXSTS(engine, xblAuth);
        MinecraftAuthResponse mcAuth = MicrosoftOAuth.authenticateWithMinecraft(engine, xblAuth, xstsAuth);
        MinecraftProfile profile = MicrosoftOAuth.getMinecraftProfile(engine, mcAuth);
        return new Account(profile, msAuth, mcAuth);
    }

    public static void validateAccount(HttpEngine engine, Account account) throws IOException {
        System.out.println("[DevLogin] Validating account..");
        if (System.currentTimeMillis() >= account.mcTokens.expiresAt) {
            System.out.println("[DevLogin] Minecraft token expired.");
            MicrosoftOAuth.refreshMinecraftToken(engine, account);
        }
        System.out.println("[DevLogin] Account validated.");
    }

    private static void refreshMinecraftToken(HttpEngine engine, Account account) throws IOException {
        System.out.println("[DevLogin] Refreshing Minecraft Token..");
        if (System.currentTimeMillis() >= account.msTokens.expiresAt) {
            System.out.println("[DevLogin] Microsoft Token expired.");
            MicrosoftOAuth.refreshMicrosoftToken(engine, account);
        }
        XBLAuthenticationResponse xblAuth = MicrosoftOAuth.authenticateWithXBL(engine, account.msTokens.accessToken);
        XSTSAuthenticationResponse xstsAuth = MicrosoftOAuth.authenticateWithXSTS(engine, xblAuth);
        MinecraftAuthResponse mcAuth = MicrosoftOAuth.authenticateWithMinecraft(engine, xblAuth, xstsAuth);
        MinecraftProfile profile = MicrosoftOAuth.getMinecraftProfile(engine, mcAuth);
        account.username = profile.name;
        account.uuid = profile.uuid();
        account.mcTokens = new Account.MCTokens(mcAuth);
        System.out.println("[DevLogin] Minecraft Token refreshed.");
    }

    private static void refreshMicrosoftToken(HttpEngine engine, Account account) throws IOException {
        System.out.println("[DevLogin] Refreshing Microsoft Token..");
        account.msTokens = new Account.MSTokens(MicrosoftOAuth.refreshMicrosoftAuth(engine, account.msTokens));
        System.out.println("[DevLogin] Microsoft Token refreshed.");
    }

    private static XBLAuthenticationResponse authenticateWithXBL(HttpEngine engine, String authToken) throws IOException {
        HttpResponse resp = engine.postJson(XBL_AUTH_URL, DevLogin.GSON, ColUtils.mapOf("Properties", ColUtils.mapOf("AuthMethod", "RPS", "SiteName", "user.auth.xboxlive.com", "RpsTicket", "d=" + authToken), "RelyingParty", "http://auth.xboxlive.com", "TokenType", "JWT"));
        if (resp.code != 200 || resp.body == null) {
            if (resp.body != null) {
                throw new RuntimeException("XBoxLive Authentication failed. Status code: " + resp.code + " Body: " + resp.fromJson(DevLogin.GSON, (Type)((Object)XboxApiError.class)));
            }
            throw new RuntimeException("XBoxLive Authentication failed. Got status code: " + resp.code);
        }
        System.out.println("[DevLogin] Logged into XBoxLive!");
        return (XBLAuthenticationResponse)resp.fromJson(DevLogin.GSON, (Type)((Object)XBLAuthenticationResponse.class));
    }

    private static XSTSAuthenticationResponse authenticateWithXSTS(HttpEngine engine, XBLAuthenticationResponse auth) throws IOException {
        HttpResponse resp = engine.postJson(XSTS_AUTH_URL, DevLogin.GSON, ColUtils.mapOf("Properties", ColUtils.mapOf("SandboxId", "RETAIL", "UserTokens", Collections.singletonList(auth.token)), "RelyingParty", "rp://api.minecraftservices.com/", "TokenType", "JWT"));
        if (resp.code != 200) {
            XboxApiError error = (XboxApiError)resp.fromJson(DevLogin.GSON, (Type)((Object)XboxApiError.class));
            if (error.xErr == 2148916233L) {
                System.out.println("[DevLogin] You don't have an XBoxLive account. Please login to Minecraft at least once in the Vanilla launcher.");
            } else if (error.xErr == 2148916235L) {
                System.out.println("[DevLogin] XBoxLive is not available or banned in your country.");
            } else if (error.xErr == 2148916236L || error.xErr == 2148916237L) {
                System.out.println("[DevLogin] Your account needs adult verification. (South Korea)");
            } else if (error.xErr == 2148916238L) {
                System.out.println("[DevLogin] Your account is a child account and must be added to a Family by an adult.");
            } else if (error.message != null) {
                System.out.println("[DevLogin] Unknown XSTS Login error: " + error.message);
            } else {
                System.out.println("[DevLogin] Unknown XSTS Login error: " + error.xErr);
            }
            System.exit(1);
        }
        System.out.println("[DevLogin] Logged into XSTS!");
        return (XSTSAuthenticationResponse)resp.fromJson(DevLogin.GSON, (Type)((Object)XSTSAuthenticationResponse.class));
    }

    private static MinecraftAuthResponse authenticateWithMinecraft(HttpEngine engine, XBLAuthenticationResponse xblAuth, XSTSAuthenticationResponse xstsAuth) throws IOException {
        HttpResponse resp = engine.postJson(MINECRAFT_XBOX_LOGIN_URL, DevLogin.GSON, ColUtils.mapOf("identityToken", "XBL3.0 x=" + xblAuth.getUserId() + ";" + xstsAuth.token, "ensureLegacyEnabled", "true"));
        if (resp.code != 200) {
            MinecraftApiError error = (MinecraftApiError)resp.fromJson(DevLogin.GSON, (Type)((Object)MinecraftApiError.class));
            throw new RuntimeException(error.developerMessage != null ? error.developerMessage : "Minecraft api error: " + error);
        }
        System.out.println("[DevLogin] Logged into Minecraft!");
        return (MinecraftAuthResponse)resp.fromJson(DevLogin.GSON, (Type)((Object)MinecraftAuthResponse.class));
    }

    private static MinecraftProfile getMinecraftProfile(HttpEngine engine, MinecraftAuthResponse auth) throws IOException {
        HttpResponse resp = engine.getJson(MINECRAFT_PROFILE_URL, ColUtils.mapOf("Authorization", "Bearer " + auth.accessToken));
        if (resp.code != 200) {
            MinecraftApiError error = (MinecraftApiError)resp.fromJson(DevLogin.GSON, (Type)((Object)MinecraftApiError.class));
            throw new RuntimeException(error.developerMessage != null ? error.developerMessage : "Minecraft api error: " + error);
        }
        System.out.println("[DevLogin] Got Minecraft profile!");
        return (MinecraftProfile)resp.fromJson(DevLogin.GSON, (Type)((Object)MinecraftProfile.class));
    }

    public static class GrantExpiredException
    extends RuntimeException {
        public final MicrosoftApiError error;

        public GrantExpiredException(MicrosoftApiError error) {
            super(error.errorDescription);
            this.error = error;
        }
    }
}

