/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.devlogin.util;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class JsonUtils {
    public static <T> T parse(Gson gson, Path path, Type t) throws IOException, JsonParseException {
        return JsonUtils.parse(gson, Files.newInputStream(path, new OpenOption[0]), t);
    }

    public static <T> T parse(Gson gson, String str, Type t) throws IOException, JsonParseException {
        return JsonUtils.parse(gson, new StringReader(str), t);
    }

    public static <T> T parse(Gson gson, InputStream is, Type t) throws IOException, JsonParseException {
        return JsonUtils.parse(gson, new InputStreamReader(is), t);
    }

    public static <T> T parse(Gson gson, Reader reader, Type t) throws IOException, JsonParseException {
        try (Reader r = reader;){
            Object object = gson.fromJson(r, t);
            return (T)object;
        }
    }

    public static void write(Gson gson, Path path, Object instance) throws IOException, JsonIOException {
        JsonUtils.write(gson, path, instance, instance.getClass());
    }

    public static void write(Gson gson, Path path, Object instance, Type t) throws IOException, JsonIOException {
        JsonUtils.write(gson, Files.newOutputStream(path, new OpenOption[0]), instance, t);
    }

    public static void write(Gson gson, OutputStream os, Object instance) throws IOException, JsonIOException {
        JsonUtils.write(gson, os, instance, instance.getClass());
    }

    public static void write(Gson gson, OutputStream os, Object instance, Type t) throws IOException, JsonIOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(os);){
            gson.toJson(instance, t, (Appendable)writer);
        }
    }
}

