/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.fastremap;

import java.util.LinkedList;
import java.util.List;
import net.covers1624.fastremap.ASMRemapper;
import net.covers1624.fastremap.FastRemapper;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class StrippedCtorFixer
extends ClassVisitor {
    private final FastRemapper fastRemapper;
    @Nullable
    private final ASMRemapper remapper;
    private final boolean forceCompute;
    private final List<FieldNode> finalFields = new LinkedList<FieldNode>();
    private boolean hasCtors = false;
    private String cName;
    private String sName;

    public StrippedCtorFixer(ClassVisitor classVisitor, FastRemapper fastRemapper, @Nullable ASMRemapper remapper, boolean forceCompute) {
        super(589824, classVisitor);
        this.fastRemapper = fastRemapper;
        this.remapper = remapper;
        this.forceCompute = forceCompute;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cName = name;
        this.sName = superName;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if ((access & 8) == 0 && (access & 0x10) != 0 && value == null) {
            this.finalFields.add(new FieldNode(name, Type.getType(descriptor)));
        }
        return super.visitField(access, name, descriptor, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (!this.hasCtors && name.equals("<init>")) {
            this.hasCtors = true;
            this.finalFields.clear();
            if (this.forceCompute) {
                this.fastRemapper.storeCtorParams(this.cName, Type.getArgumentTypes(descriptor));
            }
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (!this.hasCtors && !this.finalFields.isEmpty()) {
            Type[] fieldTypes = FastStream.of(this.finalFields).map(e -> e.desc).toArray((Type[])new Type[0]);
            Type[] superParams = this.fastRemapper.getCtorParams(this.sName);
            Type[] params = new Type[superParams.length + fieldTypes.length];
            System.arraycopy(superParams, 0, params, 0, superParams.length);
            System.arraycopy(fieldTypes, 0, params, superParams.length, fieldTypes.length);
            this.fastRemapper.storeCtorParams(this.cName, params);
            MethodVisitor mv = super.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, params), null, null);
            if (mv == null) {
                return;
            }
            assert (!this.forceCompute);
            assert (this.remapper != null);
            Label start = new Label();
            Label end = new Label();
            int localIdx = 0;
            mv.visitCode();
            mv.visitLabel(start);
            mv.visitVarInsn(25, localIdx++);
            for (Type pType : superParams) {
                mv.visitVarInsn(pType.getOpcode(21), localIdx);
                localIdx += pType.getSize();
            }
            mv.visitMethodInsn(183, this.sName, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, superParams), false);
            for (FieldNode fNode : this.finalFields) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(fNode.desc.getOpcode(21), localIdx);
                mv.visitFieldInsn(181, this.cName, fNode.name, fNode.desc.getDescriptor());
                localIdx += fNode.desc.getSize();
            }
            mv.visitInsn(177);
            mv.visitLabel(end);
            int lvtIdx = 0;
            mv.visitLocalVariable("this", Type.getObjectType(this.cName).getDescriptor(), null, start, end, lvtIdx++);
            for (Type pType : superParams) {
                mv.visitLocalVariable("super_param_" + lvtIdx, pType.getDescriptor(), null, start, end, lvtIdx);
                lvtIdx += pType.getSize();
            }
            for (FieldNode fNode : this.finalFields) {
                String name = this.remapper.mapFieldName(this.cName, fNode.name, fNode.desc.getDescriptor());
                mv.visitLocalVariable("p_" + name, fNode.desc.getDescriptor(), null, start, end, lvtIdx);
                lvtIdx += fNode.desc.getSize();
            }
            int maxStack = Math.max(1 + superParams.length, 2);
            mv.visitMaxs(maxStack, localIdx);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    private static class FieldNode {
        public final String name;
        public final Type desc;

        private FieldNode(String name, Type desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

