/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.fastremap;

import java.util.HashMap;
import java.util.Map;
import net.covers1624.fastremap.FastRemapper;
import net.minecraftforge.srgutils.IMappingFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;

public final class ASMRemapper
extends Remapper {
    private static final String[] EMPTY = new String[0];
    private final FastRemapper fastRemapper;
    private final IMappingFile mappings;
    private final Map<String, String[]> hierarchy = new HashMap<String, String[]>();
    private final Map<String, Map<String, String>> fieldCache = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> methodCache = new HashMap<String, Map<String, String>>();
    private final Map<String, String> annotationCache = new HashMap<String, String>();

    public ASMRemapper(FastRemapper fastRemapper, IMappingFile mappings) {
        this.fastRemapper = fastRemapper;
        this.mappings = mappings;
        for (IMappingFile.IClass clazz : mappings.getClasses()) {
            this.fieldCache.put(clazz.getOriginal(), new HashMap());
            this.methodCache.put(clazz.getOriginal(), new HashMap());
        }
    }

    public String map(String internalName) {
        IMappingFile.IClass clazz = this.mappings.getClass(internalName);
        return clazz != null ? clazz.getMapped() : internalName;
    }

    public String mapRecordComponentName(String owner, String name, String descriptor) {
        return this.mapFieldName(owner, name, descriptor);
    }

    public String mapAnnotationAttributeName(String descriptor, String name) {
        IMappingFile.IClass clazz = this.mappings.getClass(Type.getType((String)descriptor).getInternalName());
        if (clazz == null) {
            return name;
        }
        String mapped = this.annotationCache.get(descriptor + name);
        if (mapped != null) {
            return mapped;
        }
        for (IMappingFile.IMethod method : clazz.getMethods()) {
            if (!method.getOriginal().equals(name)) continue;
            mapped = method.getMapped();
            break;
        }
        if (mapped != null) {
            this.annotationCache.put(descriptor + name, mapped);
            return mapped;
        }
        return name;
    }

    public String mapFieldName(String owner, String name, String descriptor) {
        IMappingFile.IClass clazz = this.mappings.getClass(owner);
        if (clazz == null) {
            return name;
        }
        Map<String, String> cache = this.fieldCache.get(owner);
        assert (cache != null);
        String existing = cache.get(name + descriptor);
        if (existing != null) {
            return existing;
        }
        String ret = name;
        IMappingFile.IField field = clazz.getField(name);
        if (field == null || !field.getDescriptor().equals(descriptor)) {
            String[] parents;
            for (String parent : parents = this.getDirectSuperTypes(owner)) {
                String mapped = this.mapFieldName(parent, name, descriptor);
                if (mapped.equals(name)) continue;
                ret = mapped;
                break;
            }
        } else {
            ret = field.getMapped();
        }
        cache.put(name + descriptor, ret);
        return ret;
    }

    public String mapMethodName(String owner, String name, String descriptor) {
        IMappingFile.IClass clazz = this.mappings.getClass(owner);
        if (clazz == null) {
            return name;
        }
        Map<String, String> cache = this.methodCache.get(owner);
        assert (cache != null);
        String existing = cache.get(name + descriptor);
        if (existing != null) {
            return existing;
        }
        String ret = name;
        IMappingFile.IMethod method = clazz.getMethod(name, descriptor);
        if (method == null) {
            String[] parents;
            for (String parent : parents = this.getDirectSuperTypes(owner)) {
                String mapped = this.mapMethodName(parent, name, descriptor);
                if (mapped.equals(name)) continue;
                ret = mapped;
                break;
            }
        } else {
            ret = method.getMapped();
        }
        cache.put(name + descriptor, ret);
        return ret;
    }

    private String[] getDirectSuperTypes(String cName) {
        String[] directSuperTypes = this.hierarchy.get(cName);
        if (directSuperTypes != null) {
            return directSuperTypes;
        }
        byte[] bytes = this.fastRemapper.getClassBytes(cName);
        directSuperTypes = bytes != null ? ASMRemapper.extractSupertypes(new ClassReader(bytes)) : EMPTY;
        this.hierarchy.put(cName, directSuperTypes);
        return directSuperTypes;
    }

    public void collectDirectSupertypes(ClassReader reader) {
        String cName = reader.getClassName();
        if (!this.hierarchy.containsKey(cName)) {
            this.hierarchy.put(cName, ASMRemapper.extractSupertypes(reader));
        }
    }

    private static String[] extractSupertypes(ClassReader reader) {
        String superName = reader.getSuperName();
        String[] interfaces = reader.getInterfaces();
        if (superName == null) {
            return interfaces;
        }
        if (interfaces.length == 0) {
            return new String[]{superName};
        }
        String[] parents = new String[interfaces.length + 1];
        parents[0] = superName;
        System.arraycopy(interfaces, 0, parents, 1, interfaces.length);
        return parents;
    }
}

