/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.fastremap;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class CanonicalRecordCtorParamNameFixer
extends ClassVisitor {
    private final List<String> names = new ArrayList<String>();
    private final List<Type> types = new ArrayList<Type>();
    @Nullable
    private Type ctorType;

    public CanonicalRecordCtorParamNameFixer(ClassVisitor parent) {
        super(589824, parent);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if ((access & 8) == 0) {
            this.names.add(name);
            this.types.add(Type.getType((String)descriptor));
        }
        return super.visitField(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (!name.equals("<init>")) {
            return mv;
        }
        if (this.names.isEmpty()) {
            return mv;
        }
        if (this.ctorType == null) {
            this.ctorType = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])((Type[])this.types.toArray(Type[]::new)));
        }
        if (!Type.getMethodType((String)descriptor).equals((Object)this.ctorType)) {
            return mv;
        }
        final ArrayList<String> slottedNames = new ArrayList<String>();
        slottedNames.add("this");
        int idx = 0;
        for (Type type : this.types) {
            slottedNames.add(this.names.get(idx));
            if (type.getSize() == 2) {
                slottedNames.add(this.names.get(idx));
            }
            ++idx;
        }
        return new MethodVisitor(589824, mv){
            private int pIndex;
            {
                super(arg0, arg1);
                this.pIndex = 0;
            }

            public void visitParameter(String name, int access) {
                super.visitParameter(CanonicalRecordCtorParamNameFixer.this.names.get(this.pIndex++), access);
            }

            public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                if (index != 0 && index < slottedNames.size()) {
                    name = (String)slottedNames.get(index);
                }
                super.visitLocalVariable(name, descriptor, signature, start, end, index);
            }
        };
    }
}

