/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.fastremap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.covers1624.fastremap.ASMClassRemapper;
import net.covers1624.fastremap.FastRemapper;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class LocalVariableFixer
extends ClassVisitor {
    private final Map<String, OuterLambdaScope> lambdaMap = new HashMap<String, OuterLambdaScope>();
    private final FastRemapper remapper;
    private String cName;
    private Integer outerMethodDepth;

    public LocalVariableFixer(ClassVisitor cv, FastRemapper remapper) {
        super(589824, cv);
        this.remapper = remapper;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.cName = name;
    }

    public void visitOuterClass(String owner, String name, String desc) {
        super.visitOuterClass(owner, name, desc);
        if (name != null) {
            this.outerMethodDepth = this.remapper.getMethodDepth(owner, name + desc);
        }
    }

    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        final int paramWidth = LocalVariableFixer.getParamWidth(desc);
        final boolean isStatic = (access & 8) != 0;
        final OuterLambdaScope lambda = this.lambdaMap.get(name + desc);
        final int parentDepth = lambda != null && (access & 0x1000) != 0 ? this.remapper.getMethodDepth(this.cName, lambda.method) : (this.outerMethodDepth != null ? this.outerMethodDepth : 0);
        final String mName = name;
        final String mDesc = desc;
        return new MethodVisitor(589824, super.visitMethod(access, name, desc, signature, exceptions)){
            private final List<String> localNames;
            {
                super(arg0, arg1);
                this.localNames = new ArrayList<String>();
            }

            public String uniqueLocal(String name2) {
                if (parentDepth != 0) {
                    if (parentDepth == 1) {
                        return "l_" + name2;
                    }
                    return "l" + parentDepth + "_" + name2;
                }
                return name2;
            }

            private String nameLocal(int index) {
                int instanceOffset;
                int n = instanceOffset = isStatic ? 0 : 1;
                if (index == 0 && !isStatic) {
                    return "this";
                }
                if (lambda != null && lambda.scopeVars.size() > index) {
                    return lambda.scopeVars.get(index);
                }
                if (index < paramWidth + instanceOffset) {
                    return this.uniqueLocal("param" + (index - instanceOffset));
                }
                return this.uniqueLocal("var" + index);
            }

            public void visitLocalVariable(String name2, String descriptor, String signature, Label start, Label end, int index) {
                super.visitLocalVariable(this.nameLocal(index), descriptor, signature, start, end, index);
            }

            public void visitVarInsn(int opcode, int var) {
                if (opcode >= 21 && opcode <= 25) {
                    this.localNames.add(this.nameLocal(var));
                }
                super.visitVarInsn(opcode, var);
            }

            public void visitInvokeDynamicInsn(String name2, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                Handle targetHandle;
                super.visitInvokeDynamicInsn(name2, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
                if (ASMClassRemapper.LAMBDA_META_FACTORIES.contains(bootstrapMethodHandle) && (targetHandle = (Handle)bootstrapMethodArguments[1]).getOwner().equals(LocalVariableFixer.this.cName)) {
                    String tName = targetHandle.getName();
                    String tDesc = targetHandle.getDesc();
                    int nArgs = Type.getArgumentTypes((String)descriptor).length;
                    List vars = !this.localNames.isEmpty() ? this.localNames.subList(this.localNames.size() - nArgs, this.localNames.size()) : List.of();
                    LocalVariableFixer.this.lambdaMap.put(tName + tDesc, new OuterLambdaScope(mName + mDesc, List.copyOf(vars)));
                }
            }

            public void visitEnd() {
                LocalVariableFixer.this.remapper.storeMethodDepth(LocalVariableFixer.this.cName, name, desc, parentDepth + 1);
                super.visitEnd();
            }
        };
    }

    private static int getParamWidth(String desc) {
        int width = 0;
        for (Type arg : Type.getMethodType((String)desc).getArgumentTypes()) {
            width += arg.getSize();
        }
        return width;
    }

    private record OuterLambdaScope(String method, List<String> scopeVars) {
    }
}

