/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.fastremap;

import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class CtorAnnotationFixer
extends ClassVisitor {
    private boolean isEnum;
    @Nullable
    private String cName;
    @Nullable
    private String outerScope;

    public CtorAnnotationFixer(ClassVisitor classVisitor) {
        super(589824, classVisitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.isEnum = (access & 0x4000) != 0;
        this.cName = name;
    }

    public void visitInnerClass(String name, @Nullable String outerName, @Nullable String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
        if ((access & 8) != 0) {
            return;
        }
        if (innerName == null) {
            return;
        }
        assert (this.outerScope == null);
        if (name.equals(this.cName)) {
            if (outerName != null) {
                this.outerScope = outerName;
            } else {
                int idx = this.cName.lastIndexOf("$");
                if (idx != -1) {
                    this.outerScope = this.cName.substring(0, idx);
                }
            }
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        int nSynthetic;
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (!name.equals("<init>") || !this.isEnum && this.outerScope == null) {
            return mv;
        }
        Type[] params = Type.getArgumentTypes((String)desc);
        if (this.isEnum) {
            if (params.length <= 2) {
                return mv;
            }
            if (!params[0].getInternalName().equals("java/lang/String")) {
                return mv;
            }
            if (params[1] != Type.INT_TYPE) {
                return mv;
            }
            nSynthetic = 2;
        } else {
            if (params.length <= 1) {
                return mv;
            }
            if (!params[0].getInternalName().equals(this.outerScope)) {
                return mv;
            }
            nSynthetic = 1;
        }
        final int nParams = params.length;
        final int newNParams = nParams - nSynthetic;
        return new MethodVisitor(589824, mv){
            private boolean shiftedCount;
            {
                super(arg0, arg1);
                this.shiftedCount = false;
            }

            public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
                if (parameterCount == nParams) {
                    this.shiftedCount = true;
                    parameterCount = newNParams;
                }
                super.visitAnnotableParameterCount(parameterCount, visible);
            }

            @Nullable
            public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
                if (this.shiftedCount && parameter >= nSynthetic) {
                    parameter -= nSynthetic;
                }
                return super.visitParameterAnnotation(parameter, descriptor, visible);
            }
        };
    }
}

