/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.fastremap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.covers1624.fastremap.ASMClassRemapper;
import net.covers1624.fastremap.ASMRemapper;
import net.covers1624.fastremap.CanonicalRecordCtorParamNameFixer;
import net.covers1624.fastremap.CtorAnnotationFixer;
import net.covers1624.fastremap.Hashing;
import net.covers1624.fastremap.LocalVariableFixer;
import net.covers1624.fastremap.SourceAttributeFixer;
import net.covers1624.fastremap.StrippedCtorFixer;
import net.minecraftforge.srgutils.IMappingFile;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public final class FastRemapper {
    private static final String VERSION;
    private final PrintStream logger;
    private final List<String> excludes;
    private final List<String> strips;
    private final boolean flipMappings;
    private final boolean verbose;
    private final boolean mcBundle;
    private final boolean fixLocals;
    private final boolean fixSource;
    private final boolean fixParamAnns;
    private final boolean fixStrippedCtors;
    private final boolean fixRecordCtorParamNames;
    private final Map<String, byte[]> inputZip = new LinkedHashMap<String, byte[]>();
    private final Map<String, Integer> methodDepth = new HashMap<String, Integer>();
    private final Map<String, Type[]> ctorParams = new HashMap<String, Type[]>();
    private int remapCount;

    public static void main(String[] args) throws Throwable {
        System.exit(FastRemapper.mainI(args));
    }

    public static int mainI(String[] args) throws Throwable {
        OptionParser parser = new OptionParser();
        NonOptionArgumentSpec<String> nonOptions = parser.nonOptions();
        AbstractOptionSpec helpOpt = parser.acceptsAll(List.of("h", "help"), "Prints this help").forHelp();
        ArgumentAcceptingOptionSpec<Path> inputOpt = parser.acceptsAll(List.of("i", "input"), "Sets the input jar.").withRequiredArg().required().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec<Path> outputOpt = parser.acceptsAll(List.of("o", "output"), "Sets the output jar.").withRequiredArg().required().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec<Path> mappingsOpt = parser.acceptsAll(List.of("m", "mappings"), "The mappings to use. [Proguard,SRG,TSRG,TSRGv2,Tiny,Tinyv2]").withRequiredArg().required().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
        OptionSpecBuilder flipMappingsOpt = parser.acceptsAll(List.of("f", "flip"), "Flip the input mappings. (Useful for proguard logs)");
        ArgumentAcceptingOptionSpec<String> excludeOpt = parser.acceptsAll(List.of("e", "exclude"), "Excludes a class or package from being remapped. Comma separated. Example: 'com.google.,org.apache.'").withRequiredArg().withValuesSeparatedBy(",");
        ArgumentAcceptingOptionSpec<String> stripOpt = parser.acceptsAll(List.of("s", "strip"), "Strip files from the output. Comma separated. Example: 'com/google,org/apache/,some/file.txt'").withRequiredArg().withValuesSeparatedBy(",");
        OptionSpecBuilder mcBundleOpt = parser.acceptsAll(List.of("mc-bundle"), "Handle Modern Minecraft server bundles.");
        OptionSpecBuilder allFixesOpt = parser.acceptsAll(List.of("all-fixers"), "Automatically enable all fixers. Use the no- arguments to disable individual fixers.");
        OptionSpecBuilder fixLocalsOpt = parser.acceptsAll(List.of("fix-locals"), "Restores the LocalVariable table, giving each local names again.").availableUnless(allFixesOpt, new OptionSpec[0]);
        OptionSpecBuilder fixSourceOpt = parser.acceptsAll(List.of("fix-source"), "Recomputes source attributes.").availableUnless(allFixesOpt, new OptionSpec[0]);
        OptionSpecBuilder fixParamAnnotations = parser.acceptsAll(List.of("fix-ctor-anns"), "Fixes constructor parameter annotation indexes from Proguard.").availableUnless(allFixesOpt, new OptionSpec[0]);
        OptionSpecBuilder fixStrippedCtors = parser.acceptsAll(List.of("fix-stripped-ctors"), "Restores constructors for classes with final fields, who's Constructors have been stripped by proguard.").availableUnless(allFixesOpt, new OptionSpec[0]);
        OptionSpecBuilder fixCanonicalRecordCtorParamNames = parser.acceptsAll(List.of("fix-record-ctor-param-names"), "Fixes the parameter names for canonical record constructors, ensuring they match the field names.").availableUnless(allFixesOpt, new OptionSpec[0]);
        OptionSpecBuilder noFixLocalsOpt = parser.acceptsAll(List.of("no-fix-locals"), "Disables LocalVariable table restoration.").availableIf(allFixesOpt, new OptionSpec[0]);
        OptionSpecBuilder noFixSourceOpt = parser.acceptsAll(List.of("no-fix-source"), "Disables fixing of source attributes.").availableIf(allFixesOpt, new OptionSpec[0]);
        OptionSpecBuilder noFixParamAnnotations = parser.acceptsAll(List.of("no-fix-ctor-anns"), "Disables fixing of constructor parameter annotation indexes.").availableIf(allFixesOpt, new OptionSpec[0]);
        OptionSpecBuilder noFixStrippedCtors = parser.acceptsAll(List.of("no-fix-stripped-ctors"), "Disables restoration of stripped constructors.").availableIf(allFixesOpt, new OptionSpec[0]);
        OptionSpecBuilder noFixCanonicalRecordCtorParamNames = parser.acceptsAll(List.of("no-fix-record-ctor-param-names"), "Disable fixing of canonical record constructor parameter names.").availableIf(allFixesOpt, new OptionSpec[0]);
        OptionSpecBuilder verboseOpt = parser.acceptsAll(List.of("v", "verbose"), "Enables verbose logging.");
        OptionSet optSet = parser.parse(args);
        if (optSet.has(helpOpt)) {
            parser.printHelpOn(System.err);
            return -1;
        }
        Path inputPath = optSet.valueOf(inputOpt);
        if (Files.notExists(inputPath, new LinkOption[0])) {
            System.err.println("Expected '--input' path to exist.");
            parser.printHelpOn(System.err);
            return -1;
        }
        if (!Files.isRegularFile(inputPath, new LinkOption[0])) {
            System.err.println("Expected '--input' path to be a file.");
            parser.printHelpOn(System.err);
            return -1;
        }
        Path outputPath = optSet.valueOf(outputOpt);
        if (Files.exists(outputPath, new LinkOption[0]) && !Files.isRegularFile(outputPath, new LinkOption[0])) {
            System.err.println("Expected '--output' to not exist or be a file.");
            parser.printHelpOn(System.err);
            return -1;
        }
        Files.deleteIfExists(outputPath);
        Path mappingsPath = optSet.valueOf(mappingsOpt);
        if (Files.notExists(mappingsPath, new LinkOption[0])) {
            System.err.println("Expected '--mappings' path to exist.");
            parser.printHelpOn(System.err);
            return -1;
        }
        if (!Files.isRegularFile(mappingsPath, new LinkOption[0])) {
            System.err.println("Expected '--mappings' path to be a file.");
            parser.printHelpOn(System.err);
            return -1;
        }
        FastRemapper remapper = new FastRemapper(System.err, optSet.valuesOf(excludeOpt), optSet.valuesOf(stripOpt), optSet.has(flipMappingsOpt), optSet.has(verboseOpt), optSet.has(mcBundleOpt), FastRemapper.isSet(optSet, fixLocalsOpt, allFixesOpt, noFixLocalsOpt), FastRemapper.isSet(optSet, fixSourceOpt, allFixesOpt, noFixSourceOpt), FastRemapper.isSet(optSet, fixParamAnnotations, allFixesOpt, noFixParamAnnotations), FastRemapper.isSet(optSet, fixStrippedCtors, allFixesOpt, noFixStrippedCtors), FastRemapper.isSet(optSet, fixCanonicalRecordCtorParamNames, allFixesOpt, noFixCanonicalRecordCtorParamNames));
        remapper.run(inputPath, outputPath, mappingsPath);
        return 0;
    }

    public FastRemapper(PrintStream logger, List<String> excludes, List<String> strips, boolean flipMappings, boolean verbose, boolean mcBundle, boolean fixLocals, boolean fixSource, boolean fixParamAnns, boolean fixStrippedCtors, boolean fixRecordCtorParamNames) {
        this.logger = logger;
        this.excludes = new ArrayList<String>(excludes);
        this.strips = new ArrayList<String>(strips);
        this.flipMappings = flipMappings;
        this.verbose = verbose;
        this.mcBundle = mcBundle;
        this.fixLocals = fixLocals;
        this.fixSource = fixSource;
        this.fixParamAnns = fixParamAnns;
        this.fixStrippedCtors = fixStrippedCtors;
        this.fixRecordCtorParamNames = fixRecordCtorParamNames;
    }

    public void run(Path inputPath, Path outputPath, Path mappingsPath) throws IOException {
        ASMRemapper remapper;
        this.logger.println("Fast Remapper " + VERSION + ".");
        this.logger.println(" Input   : " + inputPath.toAbsolutePath());
        this.logger.println(" Output  : " + outputPath.toAbsolutePath());
        this.logger.println(" Mappings: " + mappingsPath.toAbsolutePath());
        this.logger.println();
        this.logger.println("Fixers enabled:");
        if (this.fixLocals) {
            this.logger.println(" - Local Variable Table fixer.");
        }
        if (this.fixSource) {
            this.logger.println(" - Source attribute fixer.");
        }
        if (this.fixParamAnns) {
            this.logger.println(" - Parameter annotation index fixer (ProGuard).");
        }
        if (this.fixStrippedCtors) {
            this.logger.println(" - Stripped constructors for final classes (ProGuard).");
        }
        if (this.fixRecordCtorParamNames) {
            this.logger.println(" - Canonical record constructor parameter renaming.");
        }
        this.logger.println();
        this.logger.println("Loading mappings..");
        try (InputStream is = Files.newInputStream(mappingsPath, new OpenOption[0]);){
            IMappingFile mappings = IMappingFile.load((InputStream)is);
            if (this.flipMappings) {
                mappings = mappings.reverse();
            }
            remapper = new ASMRemapper(this, mappings);
        }
        if (!this.mcBundle) {
            this.loadInput(Files.newInputStream(inputPath, new OpenOption[0]));
            byte[] remappedZip = this.doRemapping(remapper);
            this.logger.println("Writing zip..");
            Files.write(outputPath, remappedZip, new OpenOption[0]);
            this.logger.println("Done.");
        } else {
            CharSequence[] segs;
            this.logger.println("Opening bundle jar..");
            try (ZipFile zFile = new ZipFile(inputPath.toFile());){
                ZipEntry listEntry = zFile.getEntry("META-INF/versions.list");
                if (listEntry == null) {
                    throw new RuntimeException("Jar is not a Minecraft server bundle.");
                }
                String line = new String(zFile.getInputStream(listEntry).readAllBytes(), StandardCharsets.UTF_8).trim();
                segs = line.split("\t");
                if (segs.length != 3) {
                    throw new RuntimeException("More than one version?");
                }
                ZipEntry serverJar = zFile.getEntry("META-INF/versions/" + segs[2]);
                if (serverJar == null) {
                    throw new RuntimeException("Server jar does not exists in bundle?");
                }
                this.loadInput(zFile.getInputStream(serverJar));
            }
            byte[] output = this.doRemapping(remapper);
            segs[0] = Hashing.sha256(output);
            this.logger.println("Writing bundle har..");
            try (ZipInputStream zin = new ZipInputStream(Files.newInputStream(inputPath, new OpenOption[0]));
                 ZipOutputStream zout = new ZipOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
                ZipEntry entry;
                while ((entry = zin.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    zout.putNextEntry(new ZipEntry(entry.getName()));
                    if (entry.getName().equals("META-INF/versions.list")) {
                        zout.write(String.join((CharSequence)"\t", segs).getBytes(StandardCharsets.UTF_8));
                    } else if (entry.getName().equals("META-INF/versions/" + (String)segs[2])) {
                        zout.write(output);
                    } else {
                        zin.transferTo(zout);
                    }
                    zout.closeEntry();
                }
            }
            this.logger.println("Done.");
        }
    }

    private void loadInput(InputStream is) throws IOException {
        this.logger.println("Loading input zip..");
        try (ZipInputStream zin = new ZipInputStream(is);){
            ZipEntry entry;
            ByteArrayOutputStream obuf = new ByteArrayOutputStream(0x2000000);
            while ((entry = zin.getNextEntry()) != null) {
                zin.transferTo(obuf);
                this.inputZip.put(entry.getName(), obuf.toByteArray());
                obuf.reset();
            }
        }
    }

    private byte[] doRemapping(ASMRemapper remapper) throws IOException {
        this.logger.println("Remapping...");
        long start = System.nanoTime();
        ByteArrayOutputStream zipOut = new ByteArrayOutputStream();
        try (ZipOutputStream outputZip = new ZipOutputStream(zipOut);){
            for (Map.Entry<String, byte[]> entry : this.inputZip.entrySet()) {
                this.processEntry(remapper, entry.getKey(), entry.getValue(), outputZip);
            }
        }
        long end = System.nanoTime();
        this.logger.printf("Remapped %d classes in %s\n", this.remapCount, FastRemapper.formatDuration(end - start));
        return zipOut.toByteArray();
    }

    private void processEntry(ASMRemapper remapper, String name, byte[] data, ZipOutputStream outputZip) throws IOException {
        if (name.endsWith(".SF") || name.endsWith(".DSA") || name.endsWith(".RSA") || this.isStripped(name)) {
            return;
        }
        if (name.equals("META-INF/MANIFEST.MF")) {
            FastRemapper.processManifest(name, data, outputZip);
            return;
        }
        if (!name.endsWith(".class") || this.isExcluded(name.replace('/', '.'))) {
            FastRemapper.writeEntry(outputZip, name, data);
            return;
        }
        ClassWriter cw = new ClassWriter(0);
        ClassReader reader = new ClassReader(data);
        String cName = reader.getClassName();
        remapper.collectDirectSupertypes(reader);
        ClassVisitor cv = this.buildTransformTree(remapper, reader, (ClassVisitor)cw);
        reader.accept(cv, 0);
        String mapped = remapper.mapType(cName);
        if (this.verbose) {
            this.logger.printf("Mapping %s -> %s\n", cName, mapped);
        }
        FastRemapper.writeEntry(outputZip, mapped + ".class", cw.toByteArray());
        ++this.remapCount;
    }

    @VisibleForTesting
    ClassVisitor buildTransformTree(ASMRemapper remapper, ClassReader reader, ClassVisitor cv) {
        if (this.fixRecordCtorParamNames && reader.getSuperName().equals("java/lang/Record")) {
            cv = new CanonicalRecordCtorParamNameFixer((ClassVisitor)cv);
        }
        if (this.fixSource) {
            cv = new SourceAttributeFixer((ClassVisitor)cv);
        }
        if (this.fixParamAnns) {
            cv = new CtorAnnotationFixer((ClassVisitor)cv);
        }
        cv = new ASMClassRemapper((ClassVisitor)cv, remapper);
        if (this.fixStrippedCtors) {
            cv = new StrippedCtorFixer((ClassVisitor)cv, this, remapper, false);
        }
        if (this.fixLocals) {
            cv = new LocalVariableFixer((ClassVisitor)cv, this);
        }
        return cv;
    }

    private static void processManifest(String name, byte[] data, ZipOutputStream outputZip) throws IOException {
        Manifest manifest = new Manifest(new ByteArrayInputStream(data));
        manifest.getEntries().clear();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        manifest.write(bos);
        FastRemapper.writeEntry(outputZip, name, bos.toByteArray());
    }

    private static void writeEntry(ZipOutputStream zos, String name, byte[] data) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(0L);
        zos.putNextEntry(entry);
        zos.write(data);
        zos.closeEntry();
    }

    private boolean isExcluded(String path) {
        for (String exclude : this.excludes) {
            if (!path.startsWith(exclude)) continue;
            return true;
        }
        return false;
    }

    private boolean isStripped(String path) {
        for (String exclude : this.strips) {
            if (!path.startsWith(exclude)) continue;
            return true;
        }
        return false;
    }

    public byte @Nullable [] getClassBytes(String cName) {
        return this.inputZip.get(cName + ".class");
    }

    public void storeMethodDepth(String owner, String name, String desc, int depth) {
        this.methodDepth.put(owner + "." + name + desc, depth);
    }

    public int getMethodDepth(String owner, String method) {
        String key = owner + "." + method;
        Integer depth = this.methodDepth.get(key);
        if (depth == null) {
            depth = this.computeMethodDepth(owner, method);
        }
        return depth;
    }

    private int computeMethodDepth(String owner, String method) {
        byte[] bytes = this.getClassBytes(owner);
        if (bytes == null) {
            this.logger.println("Unable to compute used locals for missing class+method: " + owner + "." + method);
            return 1;
        }
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)new LocalVariableFixer(null, this), 0);
        return this.methodDepth.getOrDefault(owner + "." + method, 1);
    }

    public void storeCtorParams(String owner, Type[] types) {
        this.ctorParams.put(owner, types);
    }

    public Type[] getCtorParams(String owner) {
        Type[] params = this.ctorParams.get(owner);
        if (params == null) {
            params = this.computeCtorParams(owner);
        }
        return params;
    }

    private Type[] computeCtorParams(String owner) {
        if (owner.startsWith("java/lang/Object")) {
            return new Type[0];
        }
        byte[] bytes = this.getClassBytes(owner);
        if (bytes == null) {
            this.logger.println("Unable to compute ctor params for missing class: " + owner);
            return new Type[0];
        }
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)new StrippedCtorFixer(null, this, null, true), 0);
        return this.ctorParams.getOrDefault(owner, new Type[0]);
    }

    private static String formatDuration(long elapsedTimeInNs) {
        StringBuilder result = new StringBuilder();
        if (elapsedTimeInNs > 3600000000000L) {
            result.append(elapsedTimeInNs / 3600000000000L).append("h ");
        }
        if (elapsedTimeInNs > 60000000000L) {
            result.append(elapsedTimeInNs % 3600000000000L / 60000000000L).append("m ");
        }
        if (elapsedTimeInNs >= 1000000000L) {
            result.append(elapsedTimeInNs % 60000000000L / 1000000000L).append("s ");
        }
        if (elapsedTimeInNs >= 1000000L) {
            result.append(elapsedTimeInNs % 1000000000L / 1000000L).append("ms");
        }
        return result.toString();
    }

    private static boolean isSet(OptionSet optSet, OptionSpec<Void> enable, OptionSpec<Void> all, OptionSpec<Void> disable) {
        return optSet.has(all) && !optSet.has(disable) || optSet.has(enable);
    }

    static {
        String version = null;
        Package pkg = FastRemapper.class.getPackage();
        if (pkg != null) {
            version = pkg.getImplementationVersion();
        }
        VERSION = version != null ? version : "dev";
    }
}

