/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.jdkutils.JdkInstallationManager;
import net.covers1624.jdkutils.StatusRequestListener;
import net.covers1624.jdkutils.provisioning.adoptium.AdoptiumProvisioner;
import net.covers1624.quack.net.httpapi.okhttp.OkHttpEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallationTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallationTest.class);

    public static void main(String[] args2) throws Throwable {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec helpOpt = parser.acceptsAll(Arrays.asList("h", "help"), "Prints this help").forHelp();
        ArgumentAcceptingOptionSpec<String> javaVersionOpt = parser.accepts("version", "The java version.").withRequiredArg();
        ArgumentAcceptingOptionSpec<String> semverOpt = parser.accepts("semver", "The java semver version.").withRequiredArg();
        OptionSpecBuilder forceX64MacOpt = parser.accepts("forceX64Mac", "If AArch64 Mac should be treated as X64.");
        OptionSpecBuilder preferJreOpt = parser.accepts("jre", "If a JRE is all that is required.");
        OptionSet optSet = parser.parse(args2);
        if (optSet.has(helpOpt)) {
            parser.printHelpOn(System.err);
            System.exit(-1);
        }
        String version = optSet.valueOf(javaVersionOpt);
        String semver = optSet.valueOf(semverOpt);
        JavaVersion javaVersion = version != null ? JavaVersion.parse(version) : (semver != null ? JavaVersion.parse(semver) : JavaVersion.JAVA_16);
        JdkInstallationManager jdkInstallationManager = new JdkInstallationManager(Paths.get("jdks", new String[0]), new AdoptiumProvisioner(OkHttpEngine.create()));
        assert (javaVersion != null);
        JdkInstallationManager.ProvisionRequest.Builder builder = new JdkInstallationManager.ProvisionRequest.Builder().forVersion(javaVersion).preferJRE(optSet.has(preferJreOpt)).forceX64OnMac(optSet.has(forceX64MacOpt)).downloadListener(new StatusRequestListener());
        if (semver != null) {
            builder.withSemver(semver);
        }
        Path homeDir = jdkInstallationManager.provisionJdk(builder.build());
        LOGGER.info("Provisioned Java home installation: {}", (Object)homeDir);
        LOGGER.info("Testing installed JDK..");
        JavaInstall install = JavaInstall.parse(JavaInstall.getJavaExecutable(homeDir, false));
        if (install == null) {
            LOGGER.info("Failed to parse java install.");
        } else {
            LOGGER.info("Version: '{}', Lang version {}, Architecture {}, Home '{}', Has Compiler: '{}'", new Object[]{install.implVersion, install.langVersion, install.architecture, install.javaHome, install.hasCompiler});
        }
    }
}

