/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.locator.JavaLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocatorTest.class);

    public static void main(String[] args2) throws IOException {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec helpOpt = parser.acceptsAll(Arrays.asList("h", "help"), "Prints this help").forHelp();
        OptionSpecBuilder findGradleJdks = parser.accepts("find-gradle", "Find JDK's installed by Gradle.");
        OptionSpecBuilder findIntellijJdks = parser.accepts("find-intellij", "Find JDK's installed by Intellij.");
        OptionSpecBuilder ignoreOpenJ9 = parser.accepts("ignore-openj9", "Ignore OpenJ9 VMs.");
        OptionSpecBuilder useJavaw = parser.accepts("use-javaw", "If javaw should be preferred on Windows.");
        OptionSpecBuilder ignoreJres = parser.accepts("ignore-jres", "If installations not containing javac should be ignored.");
        OptionSpecBuilder rawOpt = parser.accepts("raw", "Dump raw data.");
        OptionSet optSet = parser.parse(args2);
        if (optSet.has(helpOpt)) {
            parser.printHelpOn(System.err);
            System.exit(-1);
        }
        JavaLocator.Builder builder = JavaLocator.builder();
        if (optSet.has(findGradleJdks)) {
            builder.findGradleJdks();
        }
        if (optSet.has(findIntellijJdks)) {
            builder.findIntellijJdks();
        }
        if (optSet.has(ignoreOpenJ9)) {
            builder.ignoreOpenJ9();
        }
        if (optSet.has(useJavaw)) {
            builder.useJavaw();
        }
        if (optSet.has(ignoreJres)) {
            builder.requireJdk();
        }
        List<JavaInstall> installs = builder.build().findJavaVersions();
        LOGGER.info("Found {} Java installs.", (Object)installs.size());
        for (JavaInstall install : installs) {
            if (optSet.has(rawOpt)) {
                LOGGER.info("{}", (Object)install);
                continue;
            }
            LOGGER.info("Version: '{}', Lang version {}, Home '{}', Has Compiler: '{}'", new Object[]{install.implVersion, install.langVersion, install.javaHome, install.hasCompiler});
        }
    }
}

