/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils;

import net.covers1624.quack.net.httpapi.RequestListener;

public class StatusRequestListener
implements RequestListener {
    int lastLen = 0;

    @Override
    public void start(RequestListener.Direction type) {
    }

    @Override
    public void onUpload(long total, long now) {
    }

    @Override
    public void onDownload(long total, long now) {
        String line = "Downloading... (" + this.getStatus(now, total) + ")";
        this.lastLen = line.length();
        System.out.print("\r" + line);
    }

    @Override
    public void end() {
        System.out.print("\r" + StatusRequestListener.repeat(' ', this.lastLen) + "\r");
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB";
        }
        return complete + " B";
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }

    private static String repeat(char ch, int num) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            builder.append(ch);
        }
        return builder.toString();
    }
}

