/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils.locator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.jdkutils.locator.GradleJavaLocator;
import net.covers1624.jdkutils.locator.IntelliJJavaLocator;
import net.covers1624.jdkutils.locator.LinuxJavaLocator;
import net.covers1624.jdkutils.locator.MacosJavaLocator;
import net.covers1624.jdkutils.locator.WindowsJavaLocator;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.platform.OperatingSystem;
import org.jetbrains.annotations.Nullable;

@Requires.RequiresList(value={@Requires(value="org.slf4j:slf4j-api"), @Requires(value="net.rubygrapefruit:native-platform"), @Requires(value="net.rubygrapefruit:native-platform-windows-amd64"), @Requires(value="net.rubygrapefruit:native-platform-windows-i386")})
public abstract class JavaLocator {
    private final boolean useJavaw;

    protected JavaLocator(boolean useJavaw) {
        this.useJavaw = useJavaw;
    }

    public static Builder builder() {
        return new Builder();
    }

    public abstract List<JavaInstall> findJavaVersions() throws IOException;

    protected void findJavasInFolder(List<JavaInstall> installs, Path folder) throws IOException {
        if (Files.notExists(folder, new LinkOption[0])) {
            return;
        }
        for (Path path : JavaLocator.listDir(folder)) {
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            JavaLocator.addJavaInstall(installs, JavaInstall.parse(this.getJavaExecutable(path)));
        }
    }

    protected Path getJavaExecutable(Path path) {
        return JavaInstall.getJavaExecutable(JavaInstall.getHomeDirectory(path), this.useJavaw);
    }

    protected static void addJavaInstall(List<JavaInstall> installs, @Nullable JavaInstall install) {
        if (install == null) {
            return;
        }
        if (!ColUtils.anyMatch(installs, e -> e.javaHome.equals(install.javaHome))) {
            installs.add(install);
        }
    }

    protected static List<Path> listDir(Path dir) throws IOException {
        if (Files.notExists(dir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> files = Files.list(dir);){
            List<Path> list = files.collect(Collectors.toList());
            return list;
        }
    }

    private static class CompositeLocator
    extends JavaLocator {
        private final List<JavaLocator> locators;
        private final boolean ignoreOpenJ9;
        private final boolean requireJdk;
        @Nullable
        private final JavaVersion filter;

        public CompositeLocator(List<JavaLocator> locators, boolean ignoreOpenJ9, boolean requireJdk, @Nullable JavaVersion filter) {
            super(false);
            this.locators = locators;
            this.ignoreOpenJ9 = ignoreOpenJ9;
            this.requireJdk = requireJdk;
            this.filter = filter;
        }

        @Override
        public List<JavaInstall> findJavaVersions() throws IOException {
            ArrayList<JavaInstall> installs = new ArrayList<JavaInstall>();
            for (JavaLocator locator : this.locators) {
                installs.addAll(locator.findJavaVersions());
            }
            return FastStream.of(installs).filter(e -> this.filter == null || this.filter == e.langVersion).filter(e -> !this.ignoreOpenJ9 || !e.isOpenJ9).filter(e -> !this.requireJdk || e.hasCompiler).toList();
        }
    }

    public static class Builder {
        private final List<JavaLocator> locators = new ArrayList<JavaLocator>(3);
        private boolean useJavaw;
        private boolean findIntellijJdks;
        private boolean findGradleJdks;
        private boolean ignoreOpenJ9;
        private boolean requireJdk;
        @Nullable
        private JavaVersion filter;
        private boolean withoutSystemSearch;

        public Builder useJavaw() {
            this.useJavaw = true;
            return this;
        }

        public Builder findIntellijJdks() {
            this.findIntellijJdks = true;
            return this;
        }

        public Builder findGradleJdks() {
            this.findGradleJdks = true;
            return this;
        }

        public Builder ignoreOpenJ9() {
            this.ignoreOpenJ9 = true;
            return this;
        }

        public Builder requireJdk() {
            this.requireJdk = true;
            return this;
        }

        public Builder filter(JavaVersion filter) {
            this.filter = filter;
            return this;
        }

        public Builder withoutSystemSearch() {
            this.withoutSystemSearch = true;
            return this;
        }

        public Builder withCustomLocator(JavaLocator locator) {
            this.locators.add(locator);
            return this;
        }

        public JavaLocator build() {
            if (!this.withoutSystemSearch) {
                OperatingSystem os = OperatingSystem.current();
                switch (os) {
                    case WINDOWS: {
                        this.locators.add(new WindowsJavaLocator(this.useJavaw));
                        break;
                    }
                    case LINUX: {
                        this.locators.add(new LinuxJavaLocator());
                        break;
                    }
                    case MACOS: {
                        this.locators.add(new MacosJavaLocator());
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unable to locate Java installations on " + (Object)((Object)os)));
                    }
                }
            }
            if (this.findIntellijJdks) {
                this.locators.add(new IntelliJJavaLocator(this.useJavaw));
            }
            if (this.findGradleJdks) {
                this.locators.add(new GradleJavaLocator(this.useJavaw));
            }
            if (this.locators.isEmpty()) {
                throw new IllegalStateException("No locators configured.");
            }
            return new CompositeLocator(this.locators, this.ignoreOpenJ9, this.requireJdk, this.filter);
        }
    }
}

