/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils.locator;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.locator.JavaLocator;
import net.covers1624.quack.collection.FastStream;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.jetbrains.annotations.Nullable;

public class WindowsJavaLocator
extends JavaLocator {
    private static final String[] ORACLE = new String[]{"SOFTWARE\\JavaSoft\\Java Development Kit", "SOFTWARE\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\JavaSoft\\JRE", "SOFTWARE\\JavaSoft\\JDK", "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Development Kit", "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\Wow6432Node\\JavaSoft\\JRE", "SOFTWARE\\Wow6432Node\\JavaSoft\\JDK"};
    private static final String[] ADOPT_OPEN_JDK = new String[]{"SOFTWARE\\AdoptOpenJDK\\JDK", "SOFTWARE\\AdoptOpenJDK\\JRE", "SOFTWARE\\Wow6432Node\\AdoptOpenJDK\\JDK", "SOFTWARE\\Wow6432Node\\AdoptOpenJDK\\JRE"};
    private static final String[] ADOPTIUM = new String[]{"SOFTWARE\\Eclipse Foundation\\JDK", "SOFTWARE\\Eclipse Foundation\\JRE", "SOFTWARE\\Wow6432Node\\Eclipse Foundation\\JDK", "SOFTWARE\\Wow6432Node\\Eclipse Foundation\\JRE", "SOFTWARE\\Eclipse Adoptium\\JDK", "SOFTWARE\\Eclipse Adoptium\\JRE", "SOFTWARE\\Wow6432Node\\Eclipse Adoptium\\JDK", "SOFTWARE\\Wow6432Node\\Eclipse Adoptium\\JRE"};
    private static final String[] MICROSOFT = new String[]{"SOFTWARE\\Microsoft\\JDK", "SOFTWARE\\Microsoft\\JRE", "SOFTWARE\\Wow6432Node\\Microsoft\\JDK", "SOFTWARE\\Wow6432Node\\Microsoft\\JRE"};
    private static final String[] PATHS = new String[]{"C:/Program Files/AdoptOpenJDK/", "C:/Program Files/Eclipse Foundation/", "C:/Program Files/Eclipse Adoptium/", "C:/Program Files/Java/", "C:/Program Files/Microsoft/", "C:/Program Files (x86)/AdoptOpenJDK/", "C:/Program Files (x86)/Eclipse Foundation/", "C:/Program Files (x86)/Eclipse Adoptium/", "C:/Program Files (x86)/Java", "C:/Program Files (x86)/Microsoft/"};

    WindowsJavaLocator(boolean useJavaw) {
        super(useJavaw);
        Native.init(null);
    }

    @Override
    public List<JavaInstall> findJavaVersions() throws IOException {
        WindowsRegistry registry = Native.get(WindowsRegistry.class);
        ArrayList<JavaInstall> installs = new ArrayList<JavaInstall>();
        this.findAll(registry, installs, ORACLE, "", "JavaHome");
        this.findAll(registry, installs, ADOPT_OPEN_JDK, WindowsJavaLocator.join("hotspot", "MSI"), "Path");
        this.findAll(registry, installs, ADOPTIUM, WindowsJavaLocator.join("hotspot", "MSI"), "Path");
        this.findAll(registry, installs, MICROSOFT, WindowsJavaLocator.join("hotspot", "MSI"), "Path");
        for (String path : PATHS) {
            this.findJavasInFolder(installs, Paths.get(path, new String[0]));
        }
        return installs;
    }

    private void findAll(WindowsRegistry registry, List<JavaInstall> installs, String[] keys2, String keySuffix, String pathKey) throws IOException {
        for (String key : keys2) {
            for (String subkey : WindowsJavaLocator.getSubkeys(registry, WindowsRegistry.Key.HKEY_LOCAL_MACHINE, key)) {
                Path javaHome = WindowsJavaLocator.getPathValue(registry, WindowsRegistry.Key.HKEY_LOCAL_MACHINE, WindowsJavaLocator.join(subkey, keySuffix), pathKey);
                if (javaHome == null) continue;
                WindowsJavaLocator.addJavaInstall(installs, JavaInstall.parse(this.getJavaExecutable(javaHome)));
            }
        }
    }

    @Nullable
    private static Path getPathValue(WindowsRegistry registry, WindowsRegistry.Key key, String subkey, String value) {
        try {
            return Paths.get(registry.getStringValue(key, subkey, value), new String[0]);
        }
        catch (MissingRegistryEntryException e) {
            return null;
        }
    }

    private static List<String> getSubkeys(WindowsRegistry registry, WindowsRegistry.Key key, String subkey) {
        try {
            return FastStream.of(registry.getSubkeys(key, subkey)).map(e -> WindowsJavaLocator.join(subkey, e)).toList();
        }
        catch (MissingRegistryEntryException e2) {
            return Collections.emptyList();
        }
    }

    private static String join(String ... strs) {
        return FastStream.of(strs).filter(e -> e != null && !e.isEmpty()).join("\\");
    }
}

