/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils.provisioning.adoptium;

import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.jdkutils.provisioning.adoptium.AdoptiumApiUtils;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.quack.net.httpapi.okhttp.OkHttpEngine;
import net.covers1624.quack.platform.Architecture;
import net.covers1624.quack.platform.OperatingSystem;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdoptiumApiUtilsTests {
    private static final String ARCH_PROP = "AdoptiumApiUtils.testing.arch";
    private static final String OS_PROP = "AdoptiumApiUtils.testing.os";
    private static final HttpEngine http = OkHttpEngine.create();

    @Test
    public void testLinuxResolve() throws Throwable {
        AdoptiumApiUtilsTests.spoofOS(Architecture.X64, OperatingSystem.LINUX, () -> {
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, true, false));
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, false, false));
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, true, true));
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, false, true));
        });
        AdoptiumApiUtilsTests.spoofOS(Architecture.AARCH64, OperatingSystem.LINUX, () -> {
            AdoptiumApiUtilsTests.assertResolves(Architecture.AARCH64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, true, false));
            AdoptiumApiUtilsTests.assertResolves(Architecture.AARCH64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, false, false));
            AdoptiumApiUtilsTests.assertResolves(Architecture.AARCH64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, true, true));
            AdoptiumApiUtilsTests.assertResolves(Architecture.AARCH64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, false, true));
        });
    }

    @Test
    public void testWindowsResolve() throws Throwable {
        AdoptiumApiUtilsTests.spoofOS(Architecture.X64, OperatingSystem.WINDOWS, () -> {
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, true, false));
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, false, false));
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, true, true));
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, false, true));
        });
    }

    @Test
    public void testMacResolve() throws Throwable {
        AdoptiumApiUtilsTests.spoofOS(Architecture.X64, OperatingSystem.MACOS, () -> {
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, true, false));
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, false, false));
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, true, true));
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, false, true));
        });
        AdoptiumApiUtilsTests.spoofOS(Architecture.AARCH64, OperatingSystem.MACOS, () -> {
            AdoptiumApiUtilsTests.assertResolves(Architecture.AARCH64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, true, false));
            AdoptiumApiUtilsTests.assertResolves(Architecture.AARCH64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, false, false));
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, true, true));
            AdoptiumApiUtilsTests.assertResolves(Architecture.X64, AdoptiumApiUtils.findRelease(http, JavaVersion.JAVA_17, null, false, true));
        });
    }

    private static void assertResolves(Architecture arch, @Nullable AdoptiumApiUtils.ReleaseResult result) {
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.releases.isEmpty());
        Assertions.assertEquals((Object)((Object)arch), (Object)((Object)result.architecture));
    }

    private static void spoofOS(Architecture arch, OperatingSystem os, SneakyUtils.ThrowingRunnable<Throwable> r) throws Throwable {
        System.setProperty(ARCH_PROP, arch.name());
        System.setProperty(OS_PROP, os.name());
        try {
            r.run();
        }
        finally {
            System.clearProperty(ARCH_PROP);
            System.clearProperty(OS_PROP);
        }
    }
}

