/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils.provisioning.adoptium;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.covers1624.jdkutils.JdkInstallationManager;
import net.covers1624.jdkutils.provisioning.adoptium.AdoptiumApiUtils;
import net.covers1624.jdkutils.provisioning.adoptium.AdoptiumRelease;
import net.covers1624.jdkutils.utils.ArchiveUtils;
import net.covers1624.jdkutils.utils.Utils;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.net.httpapi.EngineRequest;
import net.covers1624.quack.net.httpapi.EngineResponse;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.quack.net.httpapi.WebBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdoptiumProvisioner
implements JdkInstallationManager.JdkProvisioner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdoptiumProvisioner.class);
    private final HttpEngine http;

    public AdoptiumProvisioner(HttpEngine http) {
        this.http = http;
    }

    @Override
    public JdkInstallationManager.ProvisionResult provisionJdk(Path baseDir, JdkInstallationManager.ProvisionRequest request) throws IOException {
        LOGGER.info("Attempting to provision Adoptium jvm for {}({}).", (Object)request.version, (Object)request.semver);
        AdoptiumApiUtils.ReleaseResult result = AdoptiumApiUtils.findRelease(this.http, request.version, request.semver, request.jre, request.forceX64OnMac);
        if (result == null || result.releases.isEmpty()) {
            throw new FileNotFoundException("Adoptium can't provide jvm for " + (Object)((Object)request.version) + "(" + request.semver + ")");
        }
        AdoptiumRelease release = result.releases.get(0);
        if (release.binaries.isEmpty()) {
            throw new FileNotFoundException("Adoptium returned a release, but id did not contain any binaries.. " + (Object)((Object)request.version) + "(" + request.semver + ")");
        }
        if (release.binaries.size() != 1) {
            LOGGER.warn("Adoptium returned more than one binary? Api change? Using first!");
        }
        AdoptiumRelease.Binary binary = release.binaries.get(0);
        AdoptiumRelease.Package pkg = binary.pkg;
        LOGGER.info("Release found {}, Download {}", (Object)release.version_data.openjdk_version, (Object)pkg.link);
        Path archive = baseDir.resolve(pkg.name);
        LOGGER.debug("Downloading archive to {}", (Object)archive);
        EngineRequest req = this.http.newRequest().method("GET", null).url(pkg.link);
        if (request.requestListener != null) {
            req.listener(request.requestListener);
        }
        try (EngineResponse resp = req.execute();){
            int code = resp.statusCode();
            if (code < 200 || code >= 300) {
                throw new IOException("Failed to download adoptium release. Got non 2XX response " + code);
            }
            WebBody body = resp.body();
            if (body == null) {
                throw new IOException("Failed to download adoptium release. Got 2XX response with no body..");
            }
            try (ReadableByteChannel rc = body.openChannel();
                 SeekableByteChannel wc = Files.newByteChannel(IOUtils.makeParents(archive), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                IOUtils.copy(rc, wc);
            }
        }
        LOGGER.debug("File downloaded.");
        long size = Files.size(archive);
        if (size != (long)pkg.size) {
            throw new IOException("Downloaded archive size incorrect. Expected " + pkg.size + ", Got: " + size);
        }
        String hash = Utils.hashFile("SHA-256", archive);
        if (!hash.equals(pkg.checksum)) {
            throw new IOException("Downloaded archive hash incorrect. Expected " + pkg.checksum + ", Got: " + hash);
        }
        Path javaHome = ArchiveUtils.extractArchive(baseDir, archive);
        Files.deleteIfExists(archive);
        return new JdkInstallationManager.ProvisionResult(release.version_data.openjdk_version, javaHome, "jdk".equals(binary.image_type), result.architecture);
    }
}

