/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.covers1624.jdkutils.utils.JavaPropExtractGenerator;
import net.covers1624.quack.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaPropExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaPropExtractor.class);
    private static final boolean DEBUG = Boolean.getBoolean("net.covers1624.jdkutils.utils.JavaPropExtractor.debug");

    @Nullable
    public static Map<String, String> extractProperties(Path executable, List<String> propsToExtract) {
        if (DEBUG) {
            LOGGER.info("Attempting to parse properties from executable '{}'", (Object)executable);
        }
        if (Files.notExists(executable, new LinkOption[0])) {
            if (DEBUG) {
                LOGGER.error(" Executable does not exist!");
            }
            return null;
        }
        try {
            Path tempDir = Files.createTempDirectory("java_prop_extract", new FileAttribute[0]);
            JavaPropExtractGenerator.writeClass(tempDir);
            LinkedList<String> args2 = new LinkedList<String>(Arrays.asList(executable.toRealPath(new LinkOption[0]).toString(), "-Dfile.encoding=UTF8", "-cp", ".", "PropExtract"));
            args2.addAll(propsToExtract);
            ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(tempDir.toFile()).command(args2);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Process process = builder.start();
            IOUtils.copy(process.getInputStream(), os);
            try {
                boolean exited = process.waitFor(30L, TimeUnit.SECONDS);
                if (!exited) {
                    LOGGER.warn("Waited more than 30 seconds for {}. Force closing..", (Object)executable);
                    process.destroyForcibly();
                    return null;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted.", e);
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] split = line.split("=", 2);
                    if (split.length != 2) continue;
                    if (split[1].equals("null")) {
                        split[1] = null;
                    }
                    properties.put(split[0], split[1]);
                }
            }
            return properties;
        }
        catch (Throwable e) {
            if (DEBUG) {
                LOGGER.error("Failed to parse Java install.", e);
            }
            return null;
        }
    }
}

