/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.gradle.net.download;

import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.net.DownloadAction;
import net.covers1624.quack.net.download.DownloadListener;
import net.covers1624.quack.net.download.DownloadSpec;
import net.covers1624.quack.util.DataUtils;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.service.ServiceRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Requires.RequiresList(value={@Requires(value="org.gradle:gradle-api"), @Requires(value="org.apache.commons:commons-lang3"), @Requires(value="org.apache.logging.log4j:log4j-api"), @Requires(value="org.apache.httpcomponents:httpclient")})
public class ProgressLoggerListener
implements DownloadListener {
    private final ProgressLogger logger;
    @Nullable
    private String humanSize;

    public ProgressLoggerListener(ProgressLogger logger) {
        this.logger = logger;
    }

    @Override
    public void connecting() {
    }

    @Override
    public void start(long expectedLen) {
        if (expectedLen >= 0L) {
            this.humanSize = DataUtils.humanSize(expectedLen);
        }
        this.logger.started();
    }

    @Override
    public void update(long processedBytes) {
        this.logger.progress(DataUtils.humanSize(processedBytes) + "/" + this.humanSize + " downloaded");
    }

    @Override
    public void finish(long totalProcessed) {
        this.logger.completed();
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="0.5.0")
    public static ProgressLoggerListener create(Project project, DownloadSpec spec) {
        try {
            ServiceRegistry registry = ((ProjectInternal)project).getServices();
            ProgressLoggerFactory factory2 = (ProgressLoggerFactory)registry.get(ProgressLoggerFactory.class);
            return new ProgressLoggerListener(factory2.newOperation(spec.getClass()).setDescription("Download " + spec.getSrc()));
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Nullable
    public static ProgressLoggerListener create(Project project, DownloadAction action) {
        try {
            ServiceRegistry registry = ((ProjectInternal)project).getServices();
            ProgressLoggerFactory factory2 = (ProgressLoggerFactory)registry.get(ProgressLoggerFactory.class);
            return new ProgressLoggerListener(factory2.newOperation(action.getClass()).setDescription("Download " + action.getUrl()));
        }
        catch (Throwable ignored) {
            return null;
        }
    }
}

