/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.httpapi.curl4j;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import net.covers1624.quack.util.Duration;

final class HandlePool<T extends AutoCloseable> {
    private final Supplier<T> factory;
    private final LinkedList<Entry> entries = new LinkedList();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread th = new Thread(r);
        th.setName("Handle Pool Cleaner");
        th.setDaemon(true);
        return th;
    });

    public HandlePool(Supplier<T> factory2) {
        this(factory2, Duration.minutes(1L), Duration.minutes(5L));
    }

    public HandlePool(Supplier<T> factory2, Duration pollTime, Duration liveTime) {
        this.factory = factory2;
        this.executor.scheduleAtFixedRate(() -> this.clean(liveTime), pollTime.time, pollTime.time, pollTime.unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry get() {
        LinkedList<Entry> linkedList = this.entries;
        synchronized (linkedList) {
            Entry entry = this.entries.poll();
            if (entry == null) {
                entry = new Entry(this, (AutoCloseable)this.factory.get());
            }
            entry.lastUsed = System.currentTimeMillis();
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(Entry entry) {
        LinkedList<Entry> linkedList = this.entries;
        synchronized (linkedList) {
            this.entries.addFirst(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean(Duration liveTime) {
        long lt = liveTime.unit.toMillis(liveTime.time);
        LinkedList<Entry> linkedList = this.entries;
        synchronized (linkedList) {
            long currTime = System.currentTimeMillis();
            Iterator iterator2 = this.entries.iterator();
            while (iterator2.hasNext()) {
                Entry entry = (Entry)iterator2.next();
                if (entry.lastUsed + lt <= currTime) continue;
                iterator2.remove();
                try {
                    entry.handle.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static final class Entry
    implements AutoCloseable {
        public T handle;
        private long lastUsed;
        final /* synthetic */ HandlePool this$0;

        private Entry(T handle) {
            this.this$0 = this$0;
            this.handle = handle;
        }

        @Override
        public void close() {
            this.this$0.finished(this);
        }
    }
}

