/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.httpapi.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import kotlin.Pair;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.io.ForwardingReadableByteChannel;
import net.covers1624.quack.net.httpapi.EngineRequest;
import net.covers1624.quack.net.httpapi.EngineResponse;
import net.covers1624.quack.net.httpapi.HeaderList;
import net.covers1624.quack.net.httpapi.RequestListener;
import net.covers1624.quack.net.httpapi.WebBody;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.Nullable;

@Requires(value="com.squareup.okhttp3:okhttp")
public class OkHttpEngineResponse
implements EngineResponse {
    private final EngineRequest request;
    private final Response response;
    private final HeaderList headers = new HeaderList();
    @Nullable
    private final RequestListener listener;
    @Nullable
    private final WebBody body;

    public OkHttpEngineResponse(EngineRequest request, Response response, @Nullable RequestListener listener) {
        this.request = request;
        this.response = response;
        this.listener = listener;
        for (Pair<String, String> header : response.headers()) {
            this.headers.add(header.component1(), header.component2());
        }
        this.body = OkHttpEngineResponse.wrapBody(response.body(), listener);
    }

    @Override
    public EngineRequest request() {
        return this.request;
    }

    @Override
    public int statusCode() {
        return this.response.code();
    }

    @Override
    public String message() {
        return this.response.message();
    }

    @Override
    public HeaderList headers() {
        return this.headers;
    }

    @Override
    @Nullable
    public WebBody body() {
        return this.body;
    }

    @Override
    public void close() throws IOException {
        ResponseBody body = this.response.body();
        if (body != null) {
            body.close();
        }
        if (this.listener != null) {
            this.listener.end();
        }
    }

    @Nullable
    private static WebBody wrapBody(final @Nullable ResponseBody body, final @Nullable RequestListener listener) {
        if (body == null) {
            return null;
        }
        final MediaType mediaType = body.contentType();
        return new WebBody(){
            @Nullable
            private final String contentType;
            {
                this.contentType = mediaType != null ? mediaType.toString() : null;
            }

            @Override
            public ReadableByteChannel openChannel() {
                return OkHttpEngineResponse.wrapProgress(body.source(), this.length(), listener);
            }

            @Override
            public InputStream open() {
                return Channels.newInputStream(this.openChannel());
            }

            @Override
            public boolean multiOpenAllowed() {
                return false;
            }

            @Override
            public long length() {
                return body.contentLength();
            }

            @Override
            @Nullable
            public String contentType() {
                return this.contentType;
            }
        };
    }

    private static ReadableByteChannel wrapProgress(ReadableByteChannel channel, final long total, final @Nullable RequestListener listener) {
        if (listener == null) {
            return channel;
        }
        return new ForwardingReadableByteChannel(channel){
            private long curr;

            @Override
            public int read(ByteBuffer dst) throws IOException {
                int now = super.read(dst);
                if (now != -1) {
                    this.curr += (long)now;
                    listener.onDownload(total, this.curr);
                }
                return now;
            }
        };
    }
}

