/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.okhttp;

import java.io.IOException;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.net.okhttp.HasherWrappedSource;
import net.covers1624.quack.net.okhttp.SniffingResponseBody;
import net.covers1624.quack.util.MultiHasher;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Requires.RequiresList(value={@Requires(value="com.google.guava:guava"), @Requires(value="com.squareup.okhttp3:okhttp")})
public class MultiHasherInterceptor
implements Interceptor {
    @Override
    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        MultiHasher hasher = request.tag(MultiHasher.class);
        Response response = chain.proceed(request);
        if (hasher == null) {
            return response;
        }
        ResponseBody body = response.body();
        if (body == null) {
            return response;
        }
        return response.newBuilder().body(SniffingResponseBody.ofFunction(body, source2 -> new HasherWrappedSource((Source)source2, hasher))).build();
    }
}

