/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.okhttp;

import java.util.LinkedList;
import java.util.List;
import net.covers1624.quack.annotation.Requires;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Requires(value="com.squareup.okhttp3:okhttp")
public class SimpleCookieJar
implements CookieJar {
    private final List<Cookie> cookies = new LinkedList<Cookie>();

    @Override
    public void saveFromResponse(@NotNull HttpUrl httpUrl, @NotNull List<Cookie> list) {
        this.cookies.addAll(list);
    }

    @Override
    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl httpUrl) {
        LinkedList<Cookie> ret = new LinkedList<Cookie>();
        for (Cookie cookie : this.cookies) {
            if (!cookie.matches(httpUrl)) continue;
            ret.add(cookie);
        }
        return ret;
    }
}

