/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.projectbot.checker;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.covers1624.projectbot.OpenJdkProjectBot;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.net.okhttp.OkHttpDownloadAction;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ProjectChecker {
    private final Path cacheDir;
    private final Path prev;
    private final Path curr;
    private final String version;

    public ProjectChecker(Path cacheDir, String version) {
        this.cacheDir = cacheDir;
        this.prev = cacheDir.resolve("prev.html");
        this.curr = cacheDir.resolve("curr.html");
        this.version = version;
    }

    public Result checkProject(Date currTime) throws IOException {
        JEP jep;
        Document currDoc = this.requestDocument();
        Document prevDoc = this.getPrevious();
        Map<String, JEP> newJepMap = this.getJEPs(currDoc);
        Map<String, JEP> oldJepMap = this.getJEPs(prevDoc);
        LinkedList<JEPChange> jepChanges = new LinkedList<JEPChange>();
        Sets.SetView<String> newJeps = Sets.difference(newJepMap.keySet(), oldJepMap.keySet());
        Sets.SetView<String> remJeps = Sets.difference(oldJepMap.keySet(), newJepMap.keySet());
        for (String id : newJeps) {
            jep = newJepMap.get(id);
            jepChanges.add(new JEPChange(id, jep.desc, true));
        }
        for (String id : remJeps) {
            jep = oldJepMap.get(id);
            jepChanges.add(new JEPChange(id, jep.desc, false));
        }
        if (!jepChanges.isEmpty()) {
            if (Files.exists(this.prev, new LinkOption[0])) {
                Path backup = this.cacheDir.resolve("backups/" + OpenJdkProjectBot.TIME_FORMAT.format(currTime) + ".html");
                Files.move(this.prev, IOUtils.makeParents(backup), new CopyOption[0]);
            }
            Files.copy(this.curr, IOUtils.makeParents(this.prev), new CopyOption[0]);
        }
        return new Result(jepChanges);
    }

    @Nullable
    private Document getPrevious() throws IOException {
        if (Files.notExists(this.prev, new LinkOption[0])) {
            return null;
        }
        return Jsoup.parse(Files.readString(this.prev), "https://openjdk.java.net/projects/jdk/" + this.version);
    }

    private Document requestDocument() throws IOException {
        OkHttpDownloadAction action = new OkHttpDownloadAction().setQuiet(false).setUrl("https://openjdk.java.net/projects/jdk/" + this.version).setClient(OpenJdkProjectBot.HTTP_CLIENT).setDest(this.curr);
        action.execute();
        return Jsoup.parse(Files.readString(this.curr), "https://openjdk.java.net/projects/jdk/" + this.version);
    }

    private Map<String, JEP> getJEPs(@Nullable Document document) {
        if (document == null) {
            return Map.of();
        }
        LinkedHashMap<String, JEP> jeps = new LinkedHashMap<String, JEP>();
        Elements search = document.select("h2[id=Features] + blockquote > a");
        if (search.isEmpty()) {
            search = document.select(".jeps tbody a");
        }
        for (Element a : search) {
            String href = a.attr("href");
            int lastSlash = href.lastIndexOf(47);
            String id = href.substring(lastSlash + 1);
            jeps.put(id, new JEP(id, a.text()));
        }
        return jeps;
    }

    private record JEP(String id, String desc) {
    }

    public record JEPChange(String id, String desc, boolean addition) {
    }

    public record Result(List<JEPChange> jepChanges) {
    }
}

