/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.hashing;

import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import net.covers1624.quack.annotation.Requires;

@Requires(value="com.google.guava:guava")
public class Murmur2HashFunction
implements HashFunction {
    private final int seed;
    private final boolean normalizeWhitespace;

    public Murmur2HashFunction() {
        this(1, false);
    }

    public Murmur2HashFunction(int seed) {
        this(seed, false);
    }

    public Murmur2HashFunction(boolean normalizeWhitespace) {
        this(1, normalizeWhitespace);
    }

    public Murmur2HashFunction(int seed, boolean normalizeWhitespace) {
        this.seed = seed;
        this.normalizeWhitespace = normalizeWhitespace;
    }

    @Override
    public Hasher newHasher() {
        return new Murmur2Hasher();
    }

    @Override
    public Hasher newHasher(int expectedInputSize) {
        return new Murmur2Hasher(expectedInputSize);
    }

    @Override
    public HashCode hashInt(int input) {
        return this.newHasher(4).putInt(input).hash();
    }

    @Override
    public HashCode hashLong(long input) {
        return this.newHasher(8).putLong(input).hash();
    }

    @Override
    public HashCode hashBytes(byte[] input) {
        return this.newHasher(input.length).putBytes(input).hash();
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        return this.newHasher(len).putBytes(input, off, len).hash();
    }

    @Override
    public HashCode hashBytes(ByteBuffer input) {
        return this.newHasher(input.remaining()).putBytes(input).hash();
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence input) {
        return this.newHasher(input.length() * 2).putUnencodedChars(input).hash();
    }

    @Override
    public HashCode hashString(CharSequence input, Charset charset) {
        return this.hashBytes(input.toString().getBytes(charset));
    }

    @Override
    public <T> HashCode hashObject(T instance, Funnel<? super T> funnel) {
        Hasher hasher = this.newHasher();
        funnel.funnel(instance, hasher);
        return hasher.hash();
    }

    @Override
    public int bits() {
        return 32;
    }

    private static int readInt(byte[] bytes, int index) {
        return (bytes[index + 3] & 0xFF) << 24 | (bytes[index + 2] & 0xFF) << 16 | (bytes[index + 1] & 0xFF) << 8 | bytes[index] & 0xFF;
    }

    private class Murmur2Hasher
    implements Hasher {
        private final ByteArrayOutputStream bos;

        public Murmur2Hasher() {
            this.bos = new ByteArrayOutputStream();
        }

        public Murmur2Hasher(int expectedInputSize) {
            this.bos = new ByteArrayOutputStream(expectedInputSize);
        }

        @Override
        public Hasher putByte(byte b) {
            if (Murmur2HashFunction.this.normalizeWhitespace && (b == 9 || b == 10 || b == 13 || b == 32)) {
                return this;
            }
            this.bos.write(b);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] bytes) {
            return this.putBytes(bytes, 0, bytes.length);
        }

        @Override
        public Hasher putBytes(byte[] bytes, int off, int len) {
            if (off < 0 || off > bytes.length || len < 0 || off + len - bytes.length > 0) {
                throw new IndexOutOfBoundsException("b.len: " + bytes.length + " off: " + off + " len: " + len);
            }
            for (int i = off; i < len; ++i) {
                this.putByte(bytes[i]);
            }
            return this;
        }

        @Override
        public Hasher putBytes(ByteBuffer b) {
            if (b.hasArray()) {
                this.putBytes(b.array(), b.arrayOffset() + b.position(), b.remaining());
                b.position(b.limit());
            } else {
                for (int i = b.remaining(); i > 0; --i) {
                    this.putByte(b.get());
                }
            }
            return this;
        }

        @Override
        public Hasher putShort(short s2) {
            this.putByte((byte)s2);
            this.putByte((byte)(s2 >>> 8));
            return this;
        }

        @Override
        public Hasher putInt(int i) {
            this.putByte((byte)i);
            this.putByte((byte)(i >>> 8));
            this.putByte((byte)(i >>> 16));
            this.putByte((byte)(i >>> 24));
            return this;
        }

        @Override
        public Hasher putLong(long l) {
            for (int i = 0; i < 64; i += 8) {
                this.putByte((byte)(l >>> i));
            }
            return this;
        }

        @Override
        public Hasher putFloat(float f) {
            return this.putInt(Float.floatToRawIntBits(f));
        }

        @Override
        public Hasher putDouble(double d) {
            return this.putLong(Double.doubleToRawLongBits(d));
        }

        @Override
        public Hasher putBoolean(boolean b) {
            return this.putByte(b ? (byte)1 : 0);
        }

        @Override
        public Hasher putChar(char c) {
            this.putByte((byte)c);
            this.putByte((byte)(c >>> 8));
            return this;
        }

        @Override
        public Hasher putUnencodedChars(CharSequence charSequence) {
            int len = charSequence.length();
            for (int i = 0; i < len; ++i) {
                this.putChar(charSequence.charAt(i));
            }
            return this;
        }

        @Override
        public Hasher putString(CharSequence charSequence, Charset charset) {
            return this.putBytes(charSequence.toString().getBytes(charset));
        }

        @Override
        public <T> Hasher putObject(T instance, Funnel<? super T> funnel) {
            funnel.funnel(instance, this);
            return this;
        }

        @Override
        public HashCode hash() {
            int len;
            byte[] bytes = this.bos.toByteArray();
            int m3 = 1540483477;
            int r = 24;
            int h2 = Murmur2HashFunction.this.seed ^ len;
            int index = 0;
            for (len = bytes.length; len >= 4; len -= 4) {
                int k = Murmur2HashFunction.readInt(bytes, index);
                k *= m3;
                k ^= k >>> r;
                h2 *= m3;
                h2 ^= (k *= m3);
                index += 4;
            }
            switch (len) {
                case 3: {
                    h2 ^= (bytes[index + 2] & 0xFF) << 16;
                }
                case 2: {
                    h2 ^= (bytes[index + 1] & 0xFF) << 8;
                }
                case 1: {
                    h2 ^= bytes[index] & 0xFF;
                    h2 *= m3;
                }
            }
            h2 ^= h2 >>> 13;
            h2 *= m3;
            h2 ^= h2 >>> 15;
            return HashCode.fromInt(h2);
        }
    }
}

