/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public class ProcessExecutor {
    private final List<String> command = new ArrayList<String>();
    @Nullable
    private File directory;
    private final Map<String, String> envVars = new HashMap<String, String>();
    private final IO io = new IO();
    private final List<Consumer<ProcessExecutor>> preStartCallbacks = new ArrayList<Consumer<ProcessExecutor>>();

    public ProcessExecutor() {
    }

    public ProcessExecutor(ProcessBuilder from) {
        this.command.addAll(from.command());
        this.directory = from.directory();
        this.envVars.putAll(from.environment());
    }

    public ProcessExecutor addCmdArg(String arg) {
        this.command.add(arg);
        return this;
    }

    public ProcessExecutor addCmdArgs(String ... args2) {
        return this.addCmdArgs(Arrays.asList(args2));
    }

    public ProcessExecutor addCmdArgs(List<String> args2) {
        this.command.addAll(args2);
        return this;
    }

    public ProcessExecutor setCmd(String ... args2) {
        return this.setCmd(Arrays.asList(args2));
    }

    public ProcessExecutor setCmd(List<String> args2) {
        this.command.clear();
        this.command.addAll(args2);
        return this;
    }

    public List<String> getCmd() {
        return Collections.unmodifiableList(this.command);
    }

    public ProcessExecutor setWorkingDir(@Nullable File dir) {
        this.directory = dir;
        return this;
    }

    @Nullable
    public File getWorkingDir() {
        return this.directory;
    }

    public ProcessExecutor addEnvVar(String key, String value) {
        this.envVars.put(key, value);
        return this;
    }

    public ProcessExecutor addEnvVars(Map<String, String> envVars) {
        this.envVars.putAll(envVars);
        return this;
    }

    public ProcessExecutor setEnvVars(Map<String, String> envVars) {
        this.envVars.clear();
        this.envVars.putAll(envVars);
        return this;
    }

    public Map<String, String> getEnvVars() {
        return Collections.unmodifiableMap(this.envVars);
    }

    public ProcessExecutor addPreStartCallback(Consumer<ProcessExecutor> callback) {
        this.preStartCallbacks.add(callback);
        return this;
    }

    public ProcessExecutor clearCallbacks() {
        this.preStartCallbacks.clear();
        return this;
    }

    public IO getIO() {
        return this.io;
    }

    public RunningProcess start() throws ProcessException {
        RunningProcess proc = new RunningProcess(this);
        proc.start();
        return proc;
    }

    private ProcessBuilder toBuilder() {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(this.command);
        builder.directory(this.directory);
        builder.environment().putAll(this.envVars);
        return builder;
    }

    public ProcessExecutor clone() {
        ProcessExecutor other = new ProcessExecutor();
        other.setCmd(this.getCmd());
        other.setWorkingDir(this.getWorkingDir());
        other.setEnvVars(this.getEnvVars());
        other.preStartCallbacks.addAll(this.preStartCallbacks);
        return other;
    }

    private static class IOThread
    extends Thread {
        private final Process process;
        private final SneakyUtils.ThrowingRunnable<IOException> action;

        private IOThread(Process process, SneakyUtils.ThrowingRunnable<IOException> action) {
            this.process = process;
            this.action = action;
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && this.process.isAlive()) {
                try {
                    this.action.run();
                }
                catch (IOException e) {
                    this.interrupt();
                }
            }
        }
    }

    public static class IO {
        private final String newLine = System.getProperty("line.separator");
        @Nullable
        private SneakyUtils.ThrowingConsumer<InputStream, IOException> stdOutConsumer;
        @Nullable
        private SneakyUtils.ThrowingConsumer<InputStream, IOException> stdErrConsumer;
        @Nullable
        private SneakyUtils.ThrowingConsumer<OutputStream, IOException> stdInConsumer;

        private IO() {
            this.pipeStdOut(System.out);
            this.pipeStdErr(System.err);
        }

        public IO pipeStdOut(OutputStream out) {
            this.stdOutConsumer = o -> IOUtils.copy(o, out);
            return this;
        }

        public IO pipeStdErr(OutputStream out) {
            this.stdErrConsumer = o -> IOUtils.copy(o, out);
            return this;
        }

        public IO pipeStdIn(InputStream in) {
            this.stdInConsumer = o -> IOUtils.copy(in, o);
            return this;
        }

        public IO consumeStdOutLines(Consumer<String> cons) {
            this.stdOutConsumer = this.makeLineConsumer(cons);
            return this;
        }

        public IO consumeStdErrLines(Consumer<String> cons) {
            this.stdErrConsumer = this.makeLineConsumer(cons);
            return this;
        }

        public StringBuilder consumeStdOut() {
            StringBuilder builder = new StringBuilder();
            this.consumeStdOutLines(e -> {
                builder.append((String)e);
                builder.append(this.newLine);
            });
            return builder;
        }

        public StringBuilder consumeStdErr() {
            StringBuilder builder = new StringBuilder();
            this.consumeStdErrLines(e -> {
                builder.append((String)e);
                builder.append(this.newLine);
            });
            return builder;
        }

        public IO voidStdOut() {
            this.stdOutConsumer = null;
            return this;
        }

        public IO voidStdErr() {
            this.stdErrConsumer = null;
            return this;
        }

        public IO voidStdIn() {
            this.stdInConsumer = null;
            return this;
        }

        private SneakyUtils.ThrowingConsumer<InputStream, IOException> makeLineConsumer(Consumer<String> cons) {
            return o -> {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)o));
                while ((line = reader.readLine()) != null) {
                    cons.accept(line);
                }
            };
        }

        private IO copyInternal() {
            IO copy = new IO();
            copy.stdOutConsumer = this.stdOutConsumer;
            copy.stdErrConsumer = this.stdErrConsumer;
            copy.stdInConsumer = this.stdInConsumer;
            return copy;
        }
    }

    public static class ProcessException
    extends RuntimeException {
        public ProcessException(Throwable t, String str) {
            super(str, t);
        }

        public ProcessException(String str) {
            super(str);
        }
    }

    public static class RunningProcess {
        private final ProcessExecutor executor;
        private final ProcessBuilder builder;
        private final IO io;
        @Nullable
        private Process process;
        @Nullable
        private IOThread stdOutThread;
        @Nullable
        private IOThread stdErrThread;
        @Nullable
        private IOThread stdInThread;

        private RunningProcess(ProcessExecutor executor) {
            this.executor = executor;
            this.builder = executor.toBuilder();
            this.io = executor.getIO();
        }

        private void start() throws ProcessException {
            try {
                this.executor.preStartCallbacks.forEach(e -> e.accept(this.executor));
                this.process = this.builder.start();
                IO io = this.io.copyInternal();
                InputStream stdOut = this.process.getInputStream();
                InputStream stdErr = this.process.getErrorStream();
                OutputStream stdIn = this.process.getOutputStream();
                if (io.stdOutConsumer != null) {
                    this.spawnIOThread(() -> io.stdOutConsumer.accept(stdOut));
                }
                if (io.stdErrConsumer != null) {
                    this.spawnIOThread(() -> io.stdErrConsumer.accept(stdErr));
                }
                if (io.stdInConsumer != null) {
                    this.spawnIOThread(() -> io.stdInConsumer.accept(stdIn));
                }
            }
            catch (IOException e2) {
                throw new ProcessException(e2, "Failed to start process.");
            }
        }

        private void spawnIOThread(SneakyUtils.ThrowingRunnable<IOException> action) {
            assert (this.process != null);
            IOThread ioThread = new IOThread(this.process, action);
            ioThread.setDaemon(true);
            ioThread.setName("ProcessExecutor-IOThread");
            ioThread.start();
        }

        public void stop() {
            assert (this.process != null);
            assert (this.process.isAlive());
            this.process.destroy();
        }

        public void forceStop() {
            assert (this.process != null);
            assert (this.process.isAlive());
            this.process.destroyForcibly();
        }

        public boolean isAlive() {
            assert (this.process != null);
            return this.process.isAlive();
        }

        public void waitFor() {
            this.waitFor(false);
        }

        public void waitFor(long timeout2, TimeUnit unit) {
            this.waitFor(false, timeout2, unit);
        }

        public void waitFor(boolean assertZeroExit) {
            try {
                assert (this.process != null);
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (assertZeroExit) {
                this.assertZeroExit();
            }
        }

        public void waitFor(boolean assertZeroExit, long timeout2, TimeUnit unit) {
            try {
                assert (this.process != null);
                this.process.waitFor(timeout2, unit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (assertZeroExit) {
                this.assertZeroExit();
            }
        }

        public int getExitCode() {
            assert (this.process != null);
            return this.process.exitValue();
        }

        private void assertZeroExit() {
            int code = this.getExitCode();
            if (code != 0) {
                throw new ProcessException("Non zero exit code: " + code);
            }
        }
    }
}

