/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.logging.log4j2;

import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.logging.log4j2.TracingPrintStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;

@Requires.RequiresList(value={@Requires(value="org.apache.logging.log4j:log4j-api"), @Requires(value="org.apache.logging.log4j:log4j-core")})
public class Log4jUtils {
    public static void redirectStreams() {
        Logger stdout = LogManager.getLogger("STDOUT");
        Logger stderr = LogManager.getLogger("STDERR");
        System.setOut(new TracingPrintStream(stdout));
        System.setErr(new TracingPrintStream(stderr));
    }

    public static boolean flushLogs() {
        try {
            LoggerContext ctx = (LoggerContext)LogManager.getContext();
            for (org.apache.logging.log4j.core.Logger logger : ctx.getLoggers()) {
                for (Appender appender : logger.getAppenders().values()) {
                    if (!(appender instanceof AbstractOutputStreamAppender)) continue;
                    ((OutputStreamManager)((AbstractOutputStreamAppender)appender).getManager()).flush();
                }
            }
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

