/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.okhttp;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.net.AbstractDownloadAction;
import net.covers1624.quack.net.DownloadAction;
import net.covers1624.quack.net.download.DownloadListener;
import net.covers1624.quack.net.okhttp.ProgressForwardingSource;
import net.covers1624.quack.util.SneakyUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires.RequiresList(value={@Requires(value="org.slf4j:slf4j-api"), @Requires(value="com.squareup.okhttp3:okhttp")})
public class OkHttpDownloadAction
extends AbstractDownloadAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(OkHttpDownloadAction.class);
    private static final OkHttpClient CLIENT = new OkHttpClient.Builder().build();
    private OkHttpClient client = CLIENT;
    private final Map<Class<?>, Object> tags = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException {
        String url = Objects.requireNonNull(this.url, "URL not set");
        DownloadAction.Dest dest = Objects.requireNonNull(this.dest, "Dest not set");
        Request.Builder builder = new Request.Builder().url(url);
        for (Map.Entry entry : this.headers.entrySet()) {
            for (Object value : (List)entry.getValue()) {
                builder.addHeader((String)entry.getKey(), (String)value);
            }
        }
        if (this.userAgent != null) {
            builder.addHeader("User-Agent", this.userAgent);
        }
        String etag = dest.getEtag();
        if (this.useETag && etag != null) {
            builder.addHeader("If-None-Match", etag.trim());
        }
        long lastModified = dest.getLastModified();
        if (this.onlyIfModified && lastModified != -1L) {
            builder.addHeader("If-Modified-Since", FORMAT_RFC1123.format(new Date(lastModified)));
        }
        for (Map.Entry entry : this.tags.entrySet()) {
            builder.tag((Class)SneakyUtils.unsafeCast(entry.getKey()), entry.getValue());
        }
        if (this.downloadListener != null) {
            this.downloadListener.connecting();
        }
        if (!this.quiet) {
            LOGGER.info("Connecting to {}.", (Object)url);
        }
        Throwable throwable = null;
        try (Response response = this.client.newCall(builder.build()).execute();){
            int code = response.code();
            this.validateCode(code, response.message());
            Date lastModifiedHeader = response.headers().getDate("Last-Modified");
            this.upToDate = this.calcUpToDate(code, lastModified, lastModifiedHeader);
            if (this.upToDate) {
                return;
            }
            ResponseBody body = response.body();
            if (body == null) {
                return;
            }
            long contentLen = body.contentLength();
            if (this.downloadListener != null) {
                this.downloadListener.start(contentLen);
            }
            Source s2 = body.source();
            if (this.downloadListener != null) {
                s2 = new ProgressForwardingSource(s2, this.downloadListener);
            }
            if (!this.quiet) {
                LOGGER.info("Downloading '{}'.", (Object)url);
            }
            boolean success = false;
            try (Source source2 = s2;
                 BufferedSink sink2 = Okio.buffer(Okio.sink(dest.getOutputStream()));){
                sink2.writeAll(source2);
                success = true;
            }
            finally {
                if (!this.quiet) {
                    LOGGER.info("Finished '{}'. Success? {}", (Object)url, (Object)success);
                }
                dest.onFinished(success);
            }
            if (this.onlyIfModified && lastModifiedHeader != null) {
                dest.setLastModified(lastModifiedHeader.getTime());
            }
            String eTagHeader = response.header("ETag");
            if (this.useETag && eTagHeader != null) {
                dest.setEtag(eTagHeader);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    public OkHttpDownloadAction setClient(OkHttpClient client) {
        this.client = client;
        return this;
    }

    public OkHttpDownloadAction addTag(Class<?> clazz, Object tag) {
        this.tags.put(clazz, tag);
        return this;
    }

    @Override
    public OkHttpDownloadAction setUrl(String url) {
        super.setUrl(url);
        return this;
    }

    @Override
    public OkHttpDownloadAction setDest(DownloadAction.Dest dest) {
        super.setDest(dest);
        return this;
    }

    @Override
    public OkHttpDownloadAction setDest(StringWriter sw) {
        super.setDest(sw);
        return this;
    }

    @Override
    public OkHttpDownloadAction setDest(OutputStream os) {
        super.setDest(os);
        return this;
    }

    @Override
    public OkHttpDownloadAction setDest(File file) {
        super.setDest(file);
        return this;
    }

    @Override
    public OkHttpDownloadAction setDest(Path path) {
        super.setDest(path);
        return this;
    }

    @Override
    public OkHttpDownloadAction setOnlyIfModified(boolean onlyIfModified) {
        super.setOnlyIfModified(onlyIfModified);
        return this;
    }

    @Override
    public OkHttpDownloadAction setUseETag(boolean useETag) {
        super.setUseETag(useETag);
        return this;
    }

    @Override
    public OkHttpDownloadAction setQuiet(boolean quiet) {
        super.setQuiet(quiet);
        return this;
    }

    @Override
    public OkHttpDownloadAction setUserAgent(String userAgent) {
        super.setUserAgent(userAgent);
        return this;
    }

    @Override
    public OkHttpDownloadAction addRequestHeader(String key, String value) {
        super.addRequestHeader(key, value);
        return this;
    }

    @Override
    public OkHttpDownloadAction setDownloadListener(DownloadListener downloadListener) {
        super.setDownloadListener(downloadListener);
        return this;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public Map<Class<?>, Object> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }
}

