/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.sort;

import com.google.common.graph.Graph;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.covers1624.quack.annotation.Requires;

@Requires(value="com.google.guava:guava")
public class StronglyConnectedComponentDetector<T> {
    private final Graph<T> graph;
    private Map<T, Integer> ids;
    private T[] elements;
    private int[] dfn;
    private int[] low;
    private int[] stack;
    private int top;
    private BitSet onStack;
    private Set<Set<T>> components;

    public StronglyConnectedComponentDetector(Graph<T> graph) {
        this.graph = graph;
    }

    public Set<Set<T>> getComponents() {
        if (this.components == null) {
            this.calculate();
        }
        return this.components;
    }

    private void calculate() {
        this.components = new HashSet<Set<T>>();
        int t = 0;
        this.ids = new HashMap<T, Integer>();
        Set<T> nodes = this.graph.nodes();
        this.elements = new Object[nodes.size()];
        for (T node : nodes) {
            this.ids.put(node, t);
            this.elements[t] = node;
            ++t;
        }
        int n = nodes.size();
        this.dfn = new int[n];
        this.low = new int[n];
        this.stack = new int[n];
        this.onStack = new BitSet(n);
        this.top = -1;
        for (int i = 0; i < n; ++i) {
            if (this.dfn[i] != 0) continue;
            this.dfs(i, 1);
        }
    }

    private void dfs(int now, int depth) {
        this.dfn[now] = depth;
        this.low[now] = depth;
        ++this.top;
        this.stack[this.top] = now;
        this.onStack.set(now);
        for (Object each : this.graph.successors((Object)this.elements[now])) {
            int to = this.ids.get(each);
            if (this.dfn[to] != 0) {
                if (this.low[now] <= this.dfn[to]) continue;
                this.low[now] = this.dfn[to];
                continue;
            }
            this.dfs(to, depth + 1);
            if (this.low[now] <= this.low[to]) continue;
            this.low[now] = this.low[to];
        }
        if (this.dfn[now] == this.low[now]) {
            HashSet<T> component = new HashSet<T>();
            while (this.top >= 0) {
                int t = this.stack[this.top];
                component.add(this.elements[t]);
                this.onStack.clear(t);
                --this.top;
                if (t != now) continue;
                break;
            }
            this.components.add(component);
        }
    }
}

