/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.projectbot;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.covers1624.projectbot.Config;
import net.covers1624.projectbot.checker.ProjectChecker;
import net.covers1624.projectbot.checker.ProjectListChecker;
import net.covers1624.projectbot.discord.DiscordWebhook;
import net.covers1624.quack.gson.JsonUtils;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenJdkProjectBot {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    public static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    public static final MediaType APPLICATION_JSON = MediaType.get((String)"application/json");
    public static final OkHttpClient HTTP_CLIENT = new OkHttpClient.Builder().readTimeout(Duration.ofMinutes(5L)).connectTimeout(Duration.ofMinutes(5L)).build();
    public static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-HH-mm-ss");
    public static final String JDK_LIST_URL = "https://openjdk.java.net/projects/jdk/";
    public static final String JEPS_URL = "https://openjdk.java.net/jeps/";
    public static final String DUKE_ICON = "https://ss.ln-k.net/3949e";
    private final Config config;
    private final Path cacheDir;
    private final ProjectListChecker listChecker;
    private final Map<String, ProjectChecker> projectCheckers = new HashMap<String, ProjectChecker>();

    public OpenJdkProjectBot() {
        Path configFile = Path.of("./config.json", new String[0]);
        if (Files.notExists(configFile, new LinkOption[0])) {
            LOGGER.error("Config file does not exist.");
            System.exit(1);
        }
        Config config = null;
        try {
            config = (Config)JsonUtils.parse((Gson)GSON, (Path)configFile, Config.class);
        }
        catch (JsonSyntaxException | IOException ex) {
            LOGGER.error("Unable to parse config.", ex);
            System.exit(1);
        }
        this.config = config;
        this.cacheDir = Path.of(config.cacheDir, new String[0]);
        this.listChecker = new ProjectListChecker(this.cacheDir.resolve("lists"));
    }

    public static void main(String[] args) throws Throwable {
        new OpenJdkProjectBot().run();
    }

    private void run() throws Throwable {
        EXECUTOR.scheduleAtFixedRate(this::doUpdate, 0L, 30L, TimeUnit.MINUTES);
    }

    private void doUpdate() {
        LOGGER.info("Running update..");
        try {
            Date currTime = new Date();
            ProjectListChecker.Result listResult = this.listChecker.checkProjectList(currTime);
            this.projectCheckers.keySet().removeAll((Collection<?>)Sets.difference(this.projectCheckers.keySet(), listResult.versions()));
            this.sendProjectListChanges(listResult);
            for (String version : listResult.versions()) {
                ProjectChecker projectChecker = this.projectCheckers.computeIfAbsent(version, e -> new ProjectChecker(this.cacheDir.resolve((String)e), (String)e));
                ProjectChecker.Result projectResult = projectChecker.checkProject(currTime);
                this.sendProjectChanges(version, projectResult);
            }
            LOGGER.info("Update check done.");
        }
        catch (Throwable ex) {
            LOGGER.error("Error checking for updates.", ex);
        }
    }

    private void sendProjectListChanges(ProjectListChecker.Result result) throws IOException {
        if (result.changes().isEmpty()) {
            return;
        }
        LOGGER.info("Detected Project list changes.");
        StringBuilder desc = new StringBuilder();
        for (ProjectListChecker.ProjectListChange change : result.changes()) {
            desc.append("- Release [").append(change.version()).append("](").append(JDK_LIST_URL).append(change.version()).append(") ");
            desc.append((String)(change.from() == null ? "(none)" : "`" + change.from() + "`"));
            desc.append(" -> ");
            desc.append((String)(change.to() == null ? "(none)" : "`" + change.to() + "`"));
            desc.append("\n");
        }
        for (String webhook : this.config.webhooks) {
            new DiscordWebhook(webhook).setUsername("JDK Updates").setAvatarUrl(DUKE_ICON).addEmbed(new DiscordWebhook.Embed().setTitle("JDK Project Listing").setUrl(JDK_LIST_URL).setDescription("The following Project versions have changed:\n" + desc.toString().trim())).execute();
        }
    }

    private void sendProjectChanges(String version, ProjectChecker.Result result) throws IOException {
        if (result.jepChanges().isEmpty()) {
            return;
        }
        LOGGER.info("Detected JEP changes for Project {}", (Object)version);
        StringBuilder desc = new StringBuilder();
        for (ProjectChecker.JEPChange change : result.jepChanges()) {
            if (change.addition()) {
                desc.append("Added: ");
            } else {
                desc.append("Removed: ");
            }
            desc.append("[").append(change.id()).append("](").append(JEPS_URL).append(change.id()).append(") - ").append(change.desc());
            desc.append("\n");
        }
        for (String webhook : this.config.webhooks) {
            new DiscordWebhook(webhook).setUsername("JEP Updates for Release " + version).setAvatarUrl(DUKE_ICON).addEmbed(new DiscordWebhook.Embed().setTitle("JEP Changes").setUrl(JDK_LIST_URL).setDescription("The following JEPs have changed:\n" + desc.toString().trim())).execute();
        }
    }
}

