/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.projectbot.checker;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.covers1624.projectbot.OpenJdkProjectBot;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.net.okhttp.OkHttpDownloadAction;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class ProjectListChecker {
    private final Path cacheDir;
    private final Path prev;
    private final Path curr;

    public ProjectListChecker(Path cacheDir) {
        this.cacheDir = cacheDir;
        this.prev = cacheDir.resolve("prev.html");
        this.curr = cacheDir.resolve("curr.html");
    }

    public Result checkProjectList(Date currTime) throws IOException {
        ProjectVersion version;
        Map<String, ProjectVersion> newVersions = ProjectListChecker.getVersions(this.requestDocument());
        Map<String, ProjectVersion> oldVersions = ProjectListChecker.getVersions(this.getPrevious());
        Sets.SetView newReleases = Sets.difference(newVersions.keySet(), oldVersions.keySet());
        Sets.SetView removedReleases = Sets.difference(oldVersions.keySet(), newVersions.keySet());
        Sets.SetView commonReleases = Sets.intersection(newVersions.keySet(), oldVersions.keySet());
        LinkedList<ProjectListChange> changes = new LinkedList<ProjectListChange>();
        for (String release : newReleases) {
            version = newVersions.get(release);
            changes.add(new ProjectListChange(release, null, version.desc));
        }
        for (String release : removedReleases) {
            version = oldVersions.get(release);
            changes.add(new ProjectListChange(release, version.desc, null));
        }
        for (String release : commonReleases) {
            ProjectVersion newVersion = newVersions.get(release);
            ProjectVersion oldVersion = oldVersions.get(release);
            if (newVersion.desc.equals(oldVersion.desc)) continue;
            changes.add(new ProjectListChange(release, oldVersion.desc, newVersion.desc));
        }
        if (!changes.isEmpty()) {
            if (Files.exists(this.prev, new LinkOption[0])) {
                Path backup = this.cacheDir.resolve("backups/" + OpenJdkProjectBot.TIME_FORMAT.format(currTime) + ".html");
                Files.move(this.prev, IOUtils.makeParents((Path)backup), new CopyOption[0]);
            }
            Files.copy(this.curr, IOUtils.makeParents((Path)this.prev), new CopyOption[0]);
        }
        return new Result(changes, newVersions.keySet());
    }

    @Nullable
    private Document getPrevious() throws IOException {
        if (Files.notExists(this.prev, new LinkOption[0])) {
            return null;
        }
        return Jsoup.parse((String)Files.readString(this.prev), (String)"https://openjdk.java.net/projects/jdk/");
    }

    private Document requestDocument() throws IOException {
        OkHttpDownloadAction action = new OkHttpDownloadAction().setQuiet(false).setUrl("https://openjdk.java.net/projects/jdk/").setClient(OpenJdkProjectBot.HTTP_CLIENT).setDest(this.curr);
        action.execute();
        return Jsoup.parse((String)Files.readString(this.curr), (String)"https://openjdk.java.net/projects/jdk/");
    }

    public static Map<String, ProjectVersion> getVersions(@Nullable Document document) {
        if (document == null) {
            return Map.of();
        }
        Element ul = document.select("div[id=main] ul").first();
        if (ul == null) {
            return Map.of();
        }
        LinkedHashMap<String, ProjectVersion> versions = new LinkedHashMap<String, ProjectVersion>();
        for (Element li : ul.select("li")) {
            Element a = li.child(0);
            String version = a.text();
            String desc = li.text().replaceFirst(version, "").trim();
            desc = StringUtils.removeStart((String)desc, (String)"(");
            desc = StringUtils.removeEnd((String)desc, (String)")");
            versions.put(version, new ProjectVersion(version, desc));
        }
        return versions;
    }

    public record ProjectVersion(String version, String desc) {
    }

    public record ProjectListChange(String version, @Nullable String from, @Nullable String to) {
    }

    public record Result(List<ProjectListChange> changes, Set<String> versions) {
    }
}

