/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.versionapi.controller;

import com.google.gson.Gson;
import java.util.Map;
import net.covers1624.versionapi.entity.JsonCache;
import net.covers1624.versionapi.entity.ModVersion;
import net.covers1624.versionapi.json.ForgeVersionJson;
import net.covers1624.versionapi.repo.JsonCacheRepo;
import net.covers1624.versionapi.repo.ModVersionRepository;
import net.covers1624.versionapi.service.MetricsService;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/"})
public class CheckController {
    private final Gson gson;
    private final ModVersionRepository modVersionRepo;
    private final JsonCacheRepo cacheRepo;
    private final MetricsService metrics;
    private final String empty;

    public CheckController(Gson gson, ModVersionRepository modVersionRepo, JsonCacheRepo cacheRepo, MetricsService metrics) {
        this.gson = gson;
        this.modVersionRepo = modVersionRepo;
        this.cacheRepo = cacheRepo;
        this.metrics = metrics;
        this.empty = gson.toJson((Object)new ForgeVersionJson(null, Map.of()));
    }

    @RequestMapping(value={"/check"}, produces={"application/json"})
    public ResponseEntity<String> checkVersion2(@RequestParam(value="mod") String mod, @RequestParam(value="mc") String mc) {
        return this.checkVersion(mod, mc);
    }

    @RequestMapping(value={"/check/"}, produces={"application/json"})
    public ResponseEntity<String> checkVersion(@RequestParam(value="mod") String mod, @RequestParam(value="mc") String mc) {
        JsonCache cache = this.cacheRepo.findByModIdAndMcVersion(mod, mc);
        if (cache != null) {
            this.metrics.check("forge", "cached", mod, mc);
            return ResponseEntity.ok((Object)cache.getValue());
        }
        ModVersion version = this.modVersionRepo.findVersionByModIdAndMcVersion(mod, mc);
        if (version == null) {
            this.metrics.check("forge", "failed", mod, mc);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)this.empty);
        }
        this.metrics.check("forge", "uncached", mod, mc);
        return ResponseEntity.ok((Object)this.gson.toJson((Object)ForgeVersionJson.create((ModVersion)version)));
    }
}

