/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.versionapi.controller;

import com.google.gson.Gson;
import net.covers1624.versionapi.entity.JsonCache;
import net.covers1624.versionapi.entity.ModVersion;
import net.covers1624.versionapi.json.ForgeVersionJson;
import net.covers1624.versionapi.repo.JsonCacheRepo;
import net.covers1624.versionapi.repo.ModVersionRepository;
import net.covers1624.versionapi.service.MetricsService;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/"})
public class LegacyCheckController {
    private final Gson gson;
    private final ModVersionRepository modVersionRepo;
    private final JsonCacheRepo cacheRepo;
    private final MetricsService metrics;

    public LegacyCheckController(Gson gson, ModVersionRepository modVersionRepo, JsonCacheRepo cacheRepo, MetricsService metrics) {
        this.gson = gson;
        this.modVersionRepo = modVersionRepo;
        this.cacheRepo = cacheRepo;
        this.metrics = metrics;
    }

    @RequestMapping(value={"/check_legacy"})
    public ResponseEntity<String> checkVersion(@RequestParam(value="file", required=false) String file, @RequestParam(value="version", required=false) String version, @RequestParam(value="query", defaultValue="legacy") String query) {
        JsonCache cache;
        if (file == null) {
            return ResponseEntity.ok((Object)"Err: Missing param: file");
        }
        if (version == null) {
            return ResponseEntity.ok((Object)"Err: Missing param: version");
        }
        if ("forge".equals(query) && (cache = this.cacheRepo.findByModIdAndMcVersion(file, version)) != null) {
            this.metrics.check("legacy_forge", "cached", file, version);
            return ResponseEntity.ok((Object)cache.getValue());
        }
        ModVersion v = this.modVersionRepo.findVersionByModIdAndMcVersion(file, version);
        if (v == null || v.getRecommended() == null) {
            this.metrics.check("legacy", "failed", file, version);
            return ResponseEntity.ok((Object)"Err: Unknown mod/version");
        }
        if (query.equals("legacy")) {
            this.metrics.check("legacy", "ok", file, version);
            return ResponseEntity.ok((Object)("Ret: " + v.getRecommended()));
        }
        if (query.equals("forge")) {
            this.metrics.check("legacy_forge", "ok", file, version);
            return ResponseEntity.ok((Object)this.gson.toJson((Object)ForgeVersionJson.create((ModVersion)v)));
        }
        return ResponseEntity.ok((Object)"Err: Invalid query type.");
    }
}

