/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.versionapi.security;

import java.util.Collection;
import java.util.List;
import net.covers1624.versionapi.entity.ApiKey;
import net.covers1624.versionapi.security.InsufficientPermissionsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public record ApiAuth(ApiKey apiKey) implements Authentication
{
    private final ApiKey apiKey;

    public ApiAuth(ApiKey apiKey) {
        this.apiKey = apiKey;
    }

    public void requireAdmin(String message) {
        if (!this.apiKey.isAdmin()) {
            throw new InsufficientPermissionsException(message);
        }
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return List.of();
    }

    public Object getCredentials() {
        return this.apiKey;
    }

    public Object getDetails() {
        return null;
    }

    public Object getPrincipal() {
        return this.apiKey;
    }

    public boolean isAuthenticated() {
        return true;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
    }

    public String getName() {
        return "Api Key: " + this.apiKey.getSecret();
    }

    public ApiKey apiKey() {
        return this.apiKey;
    }
}

