/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.versionapi.security;

import jakarta.servlet.Filter;
import net.covers1624.versionapi.entity.ApiKey;
import net.covers1624.versionapi.repo.ApiKeyRepository;
import net.covers1624.versionapi.security.ApiAuth;
import net.covers1624.versionapi.security.ApiKeyAuthFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
public class WebSecurityConfig {
    private final ApiKeyRepository apiKeyRepo;

    public WebSecurityConfig(ApiKeyRepository apiKeyRepo) {
        this.apiKeyRepo = apiKeyRepo;
    }

    @Bean
    public SecurityFilterChain configure(HttpSecurity http) throws Exception {
        ApiKeyAuthFilter filter = new ApiKeyAuthFilter();
        filter.setAuthenticationManager(authentication -> {
            String principal = (String)authentication.getPrincipal();
            ApiKey key = this.apiKeyRepo.findBySecret(principal);
            if (key == null) {
                throw new BadCredentialsException("Invalid API Key.");
            }
            return new ApiAuth(key);
        });
        http.headers(AbstractHttpConfigurer::disable).securityMatcher(new String[]{"/api/**"}).csrf(AbstractHttpConfigurer::disable).sessionManagement(e -> e.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).addFilter((Filter)filter).authorizeHttpRequests(e -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)e.anyRequest()).authenticated());
        return (SecurityFilterChain)http.build();
    }
}

