/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.versionapi.service;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.influxdb.client.WriteApi;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import java.time.Instant;
import net.covers1624.versionapi.VersionApiProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Service;

@Service
@EnableScheduling
public class MetricsService {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private final InfluxDBClient client;
    @Nullable
    private final WriteApi writeApi;
    @Nullable
    private final String org;
    @Nullable
    private final String bucket;

    public MetricsService(VersionApiProperties properties) {
        String host = properties.getInfluxHost();
        String token = properties.getInfluxToken();
        this.org = properties.getInfluxOrg();
        this.bucket = properties.getInfluxBucket();
        if (StringUtils.isEmpty((CharSequence)host) || StringUtils.isEmpty((CharSequence)token) || StringUtils.isEmpty((CharSequence)this.org) || StringUtils.isEmpty((CharSequence)this.bucket)) {
            LOGGER.warn("Influx disabled.");
            LOGGER.warn("Have host: {}", (Object)(StringUtils.isEmpty((CharSequence)host) ? "NO" : "YES"));
            LOGGER.warn("Have token: {}", (Object)(StringUtils.isEmpty((CharSequence)token) ? "NO" : "YES"));
            LOGGER.warn("Have org: {}", (Object)(StringUtils.isEmpty((CharSequence)this.org) ? "NO" : "YES"));
            LOGGER.warn("Have bucket: {}", (Object)(StringUtils.isEmpty((CharSequence)this.bucket) ? "NO" : "YES"));
            this.client = null;
            this.writeApi = null;
            return;
        }
        this.client = InfluxDBClientFactory.create((String)host, (char[])token.toCharArray());
        this.writeApi = this.client.makeWriteApi();
    }

    public void check(String type, String status, String mod, String mc) {
        if (this.writeApi == null) {
            return;
        }
        this.addPoint(Point.measurement((String)"check").addTag("type", type).addTag("status", status).addTag("mod", mod).addTag("mc", mc).addField("count", 1L).time(Instant.now(), WritePrecision.NS));
    }

    private void addPoint(Point point) {
        assert (this.writeApi != null);
        assert (this.bucket != null);
        assert (this.org != null);
        this.writeApi.writePoint(this.bucket, this.org, point);
    }
}

