/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.api.gradle.data;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.covers1624.quack.maven.MavenNotation;
import net.covers1624.wt.api.event.VersionedClass;
import org.jetbrains.annotations.Nullable;

@VersionedClass(value=2)
public class ConfigurationData
implements Serializable {
    public final String name;
    public final Set<String> extendsFrom = new HashSet<String>();
    public final List<Dependency> dependencies = new ArrayList<Dependency>();

    public ConfigurationData(String name) {
        this.name = name;
    }

    public static class ProjectDependency
    extends Dependency {
        public final String project;

        public ProjectDependency(String project) {
            this.project = project;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("project", (Object)this.project).toString();
        }
    }

    @VersionedClass(value=1)
    public static class SourceSetDependency
    extends Dependency {
        public final String name;

        public SourceSetDependency(String name) {
            this.name = name;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
        }
    }

    @VersionedClass(value=1)
    public static class MavenDependency
    extends Dependency {
        public final MavenNotation mavenNotation;
        public final File classes;
        @Nullable
        public final File sources;
        @Nullable
        public final File javadoc;

        public MavenDependency(MavenNotation mavenNotation, File classes, @Nullable File sources, @Nullable File javadoc) {
            this.mavenNotation = mavenNotation;
            this.classes = classes;
            this.sources = sources;
            this.javadoc = javadoc;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("maven_notation", (Object)this.mavenNotation).toString();
        }
    }

    @VersionedClass(value=1)
    public static abstract class Dependency
    implements Serializable {
    }
}

