/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jetbrains.annotations.Nullable;

public class DeletingFileVisitor
extends SimpleFileVisitor<Path> {
    @Nullable
    private final Path startingDir;

    public DeletingFileVisitor() {
        this(null);
    }

    public DeletingFileVisitor(@Nullable Path startingDir) {
        this.startingDir = startingDir;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Files.deleteIfExists(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, @Nullable IOException exc) throws IOException {
        if (this.startingDir == null || !this.startingDir.equals(dir)) {
            Files.deleteIfExists(dir);
        }
        return FileVisitResult.CONTINUE;
    }
}

