/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.covers1624.quack.collection.FastStream;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepoManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitRepoManager.class);
    private final Path repoDir;
    @Nullable
    private RepoConfig config;

    public GitRepoManager(Path repoDir) {
        this.repoDir = repoDir;
    }

    public GitRepoManager setConfig(String url, String branch, String commit) {
        this.config = new RepoConfig(url, branch, commit);
        return this;
    }

    public Path getRepoDir() {
        return this.repoDir;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean checkout() throws IOException {
        Git git;
        if (this.config == null) {
            throw new RuntimeException("Not configured,");
        }
        LOGGER.info("Validating clone of {} in {}", (Object)this.config.url, (Object)this.repoDir);
        TextProgressMonitor pm = new TextProgressMonitor((Writer)new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        if (Files.notExists(this.repoDir.resolve(".git/objects"), new LinkOption[0])) {
            try {
                git = Git.init().setDirectory(this.repoDir.toFile()).call();
            }
            catch (GitAPIException ex) {
                throw new RuntimeException("Failed to initialize git repo.", ex);
            }
        } else {
            git = Git.open((File)this.repoDir.toFile());
        }
        Repository repo = git.getRepository();
        RevWalk revWalk = new RevWalk(repo);
        try (Git git2 = git;){
            boolean bl;
            block28: {
                boolean branchExists;
                boolean correctBranch;
                RevWalk revWalk2;
                block26: {
                    boolean bl2;
                    block27: {
                        revWalk2 = revWalk;
                        try {
                            URIish remoteUri;
                            RemoteConfig remote = (RemoteConfig)FastStream.of((Iterable)git.remoteList().call()).filter(e -> e.getName().equals("origin")).firstOrDefault();
                            URIish uRIish = remoteUri = remote != null && !remote.getURIs().isEmpty() ? (URIish)remote.getURIs().get(0) : null;
                            if (remoteUri == null || !this.config.url.equals(remoteUri.toString())) {
                                LOGGER.info("Setting 'origin' to '{}'", (Object)this.config.url);
                                git.remoteRemove().setRemoteName("origin").call();
                                git.remoteAdd().setName("origin").setUri(new URIish(this.config.url)).call();
                            }
                            String currentBranch = repo.getBranch();
                            ObjectId currentCommitObject = repo.resolve("HEAD");
                            String currentCommit = currentCommitObject != null ? currentCommitObject.name() : null;
                            correctBranch = this.config.branch.equals(currentBranch);
                            boolean correctCommit = this.config.commit.equals(currentCommit);
                            if (!correctBranch || !correctCommit) break block26;
                            LOGGER.info("Validated. No changes.");
                            bl2 = false;
                            if (revWalk2 == null) break block27;
                        }
                        catch (Throwable throwable) {
                            if (revWalk2 != null) {
                                try {
                                    revWalk2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        revWalk2.close();
                    }
                    return bl2;
                }
                LOGGER.info("Commit or branch changed.");
                LOGGER.info("Fetching remote changes..");
                git.fetch().setProgressMonitor((ProgressMonitor)pm).call();
                ObjectId commitObject = repo.resolve(this.config.commit);
                if (commitObject == null) {
                    throw new RuntimeException("Commit " + this.config.commit + " does not exist.");
                }
                boolean bl3 = branchExists = repo.findRef("refs/heads/" + this.config.branch) != null;
                if (!branchExists) {
                    LOGGER.info("Checking out new branch {} at {}.", (Object)this.config.branch, (Object)this.config.commit);
                    git.checkout().setCreateBranch(true).setName(this.config.branch).setStartPoint(revWalk.parseCommit((AnyObjectId)commitObject)).call();
                } else {
                    LOGGER.info("Resetting current branch to HEAD..");
                    git.reset().setMode(ResetCommand.ResetType.HARD).call();
                    git.clean().setForce(true).setCleanDirectories(true).call();
                    if (!correctBranch) {
                        LOGGER.info("Switching to existing branch {}.", (Object)this.config.branch);
                        git.checkout().setName(this.config.branch).call();
                    }
                    LOGGER.info("Resetting branch to commit {}.", (Object)this.config.commit);
                    git.reset().setMode(ResetCommand.ResetType.HARD).setRef(this.config.commit).call();
                }
                LOGGER.info("Validated. Commit/branch changed.");
                bl = true;
                if (revWalk2 == null) break block28;
                revWalk2.close();
            }
            return bl;
        }
        catch (URISyntaxException | GitAPIException ex) {
            throw new IOException(ex);
        }
    }

    private record RepoConfig(String url, String branch, String commit) {
    }
}

