/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.api.workspace.runs;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.wstool.api.workspace.Dependency;
import org.jetbrains.annotations.Nullable;

public interface EvalValue {
    public String eval(Function<Dependency, @Nullable Path> var1);

    public Iterable<Dependency> collectDependencies();

    public record ClasspathValue(Set<Dependency> dependencies) implements EvalValue
    {
        @Override
        public String eval(Function<Dependency, @Nullable Path> depFunc) {
            return FastStream.of(this.dependencies).map(depFunc).filter(Objects::nonNull).map(e -> e.toAbsolutePath().toString()).join(File.pathSeparator);
        }

        @Override
        public Iterable<Dependency> collectDependencies() {
            return this.dependencies;
        }
    }

    public record StringValue(String str) implements EvalValue
    {
        @Override
        public String eval(Function<Dependency, @Nullable Path> depFunc) {
            return this.str;
        }

        @Override
        public Iterable<Dependency> collectDependencies() {
            return List.of();
        }
    }
}

