/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.api;

import java.nio.file.Path;
import java.util.HashMap;
import net.covers1624.quack.util.SneakyUtils;

public interface Environment {
    public Path systemFolder();

    public Path projectRoot();

    public Path projectCache();

    public <T> void putService(Class<? extends T> var1, T var2);

    public <T> T getService(Class<? extends T> var1);

    public static Environment of() {
        return Environment.of(Path.of(System.getProperty("user.home"), ".workspace_tool"), Path.of(".", new String[0]).toAbsolutePath().normalize());
    }

    public static Environment of(Path sysFolder, Path projectRoot) {
        return Environment.of(sysFolder, projectRoot, projectRoot.resolve(".wstool/"));
    }

    public static Environment of(final Path sysFolder, final Path projectRoot, final Path projectCache) {
        final HashMap serviceMap = new HashMap();
        return new Environment(){

            @Override
            public Path systemFolder() {
                return sysFolder;
            }

            @Override
            public Path projectRoot() {
                return projectRoot;
            }

            @Override
            public Path projectCache() {
                return projectCache;
            }

            @Override
            public <T> void putService(Class<? extends T> clazz, T thing) {
                if (serviceMap.containsKey(clazz)) {
                    throw new IllegalArgumentException("Unable to replace a service.");
                }
                serviceMap.put(clazz, thing);
            }

            @Override
            public <T> T getService(Class<? extends T> clazz) {
                Object service = serviceMap.get(clazz);
                if (service == null) {
                    throw new IllegalStateException("Service " + clazz.getName() + " is not available.");
                }
                return (T)SneakyUtils.unsafeCast(service);
            }
        };
    }
}

