/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.api.workspace.runs;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.wstool.api.workspace.Dependency;
import net.covers1624.wstool.api.workspace.runs.EvalValue;
import org.jetbrains.annotations.Nullable;

public class EvalList {
    private final List<EvalValue> values = new ArrayList<EvalValue>();

    public void add(String str) {
        this.addEval(new EvalValue.StringValue(str));
    }

    public void addEval(EvalValue value) {
        this.values.add(value);
    }

    public void addAll(List<String> entries) {
        entries.forEach(e -> this.values.add(new EvalValue.StringValue((String)e)));
    }

    public void addAllEval(List<EvalValue> entries) {
        this.values.addAll(entries);
    }

    public void addFirst(String str) {
        this.addFirst(List.of(str));
    }

    public void addFirstEval(EvalValue value) {
        this.addFirstEval(List.of(value));
    }

    public void addFirst(List<String> entries) {
        this.addFirstEval(FastStream.of(entries).map(EvalValue.StringValue::new).toList(FastStream.infer()));
    }

    public void addFirstEval(List<EvalValue> entries) {
        this.values.addAll(0, entries);
    }

    public List<EvalValue> toList() {
        return Collections.unmodifiableList(this.values);
    }

    public List<String> toList(Function<Dependency, @Nullable Path> depFunc) {
        return FastStream.of(this.values).map(e -> e.eval(depFunc)).toList();
    }
}

