/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.api.workspace.runs;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.wstool.api.workspace.Dependency;
import net.covers1624.wstool.api.workspace.runs.EvalValue;
import org.jetbrains.annotations.Nullable;

public class EvalMap {
    private final Map<String, EvalValue> values = new LinkedHashMap<String, EvalValue>();

    public void put(String key, String value) {
        this.putEval(key, new EvalValue.StringValue(value));
    }

    public void putEval(String key, EvalValue value) {
        this.values.put(key, value);
    }

    public void putAll(Map<String, String> values) {
        values.forEach((k, v) -> this.values.put((String)k, new EvalValue.StringValue((String)v)));
    }

    public void putAllEval(Map<String, EvalValue> values) {
        this.values.putAll(values);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Map<String, EvalValue> toMap() {
        return Collections.unmodifiableMap(this.values);
    }

    public Map<String, String> toMap(Function<Dependency, @Nullable Path> depFunc) {
        return FastStream.of(this.values.entrySet()).toLinkedHashMap(Map.Entry::getKey, e -> ((EvalValue)e.getValue()).eval(depFunc));
    }
}

