/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.api;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.jdkutils.JdkInstallationManager;
import net.covers1624.jdkutils.locator.JavaLocator;
import net.covers1624.jdkutils.provisioning.adoptium.AdoptiumProvisioner;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.quack.util.LazyValue;
import net.covers1624.wstool.api.Environment;

public final class JdkProvider {
    private final JavaLocator locator = JavaLocator.builder().useJavaw().findGradleJdks().findIntellijJdks().ignoreOpenJ9().build();
    private final JdkInstallationManager installer;
    private final LazyValue<List<JavaInstall>> installs;

    public JdkProvider(Environment env, HttpEngine http) {
        this.installer = new JdkInstallationManager(env.systemFolder().resolve("jdks/"), (JdkInstallationManager.JdkProvisioner)new AdoptiumProvisioner(http));
        this.installs = new LazyValue(() -> {
            try {
                return this.locator.findJavaVersions();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to find java versions.", ex);
            }
        });
    }

    public Path findOrProvisionJdk(JavaVersion version) {
        for (JavaInstall javaInstall : (List)this.installs.get()) {
            if (!javaInstall.hasCompiler || javaInstall.langVersion != version) continue;
            return javaInstall.javaHome;
        }
        try {
            return this.installer.provisionJdk(new JdkInstallationManager.ProvisionRequest.Builder().forVersion(version).build());
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to provision JDK.", ex);
        }
    }
}

