/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wstool.api;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.covers1624.quack.gson.JsonUtils;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.util.HashUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashContainer.class);
    private static final Gson GSON = new Gson();
    private final Path hashFile;
    private final Container container;

    public HashContainer(Path dir, String name) {
        this.hashFile = dir.resolve(name + ".json");
        Container container = null;
        if (Files.exists(this.hashFile, new LinkOption[0])) {
            try {
                container = (Container)JsonUtils.parse((Gson)GSON, (Path)this.hashFile, Container.class);
            }
            catch (IOException ex) {
                LOGGER.error("Unable to load hashes from {}.", (Object)this.hashFile, (Object)ex);
            }
        }
        if (container == null) {
            container = new Container(new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>());
        }
        this.container = container;
    }

    public Entry getEntry(String key) {
        return new Entry(key, this.container.hashes.get(key));
    }

    public PropertyEntry getProperty(String property) {
        return new PropertyEntry(property, this.container.properties.get(property));
    }

    private void save() {
        try {
            JsonUtils.write((Gson)GSON, (Path)IOUtils.makeParents((Path)this.hashFile), (Object)this.container);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to save hashes into {}.", (Object)this.hashFile, (Object)ex);
        }
    }

    private record Container(Map<String, String> hashes, Map<String, String> properties) {
    }

    public class Entry {
        public final String key;
        @Nullable
        private final String value;
        private final List<Consumer<Hasher>> actions = new ArrayList<Consumer<Hasher>>();

        private Entry(@Nullable String key, String value) {
            this.key = key;
            this.value = value;
        }

        private String result() {
            Hasher hasher = Hashing.sha256().newHasher();
            this.actions.forEach(e -> e.accept(hasher));
            return hasher.hash().toString();
        }

        public Entry putString(String str) {
            this.actions.add(h -> h.putString((CharSequence)str, StandardCharsets.UTF_8));
            return this;
        }

        public Entry putFile(Path file) {
            this.actions.add(h -> {
                try {
                    if (Files.exists(file, new LinkOption[0])) {
                        HashUtils.addToHasher((Hasher)h, (Path)file);
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to read file for hashing. " + String.valueOf(file), ex);
                }
            });
            return this;
        }

        public boolean changed() {
            return !this.result().equals(this.value);
        }

        public void pushChanges() {
            HashContainer.this.container.hashes.put(this.key, this.result());
            HashContainer.this.save();
        }
    }

    public class PropertyEntry {
        private final String name;
        @Nullable
        private String value;

        private PropertyEntry(@Nullable String name, String value) {
            this.name = name;
            this.value = value;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        public boolean getBoolean() {
            return Boolean.parseBoolean(this.value);
        }

        public PropertyEntry withDefault(String value) {
            if (!this.hasValue()) {
                this.setValue(value);
            }
            return this;
        }

        public PropertyEntry withDefault(boolean value) {
            if (!this.hasValue()) {
                this.setValue(value);
            }
            return this;
        }

        public PropertyEntry setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public PropertyEntry setValue(boolean value) {
            this.value = Boolean.toString(value);
            this.push();
            return this;
        }

        public void remove() {
            this.setValue(null);
            this.push();
        }

        public void push() {
            if (this.value == null) {
                HashContainer.this.container.properties.remove(this.name);
            } else {
                HashContainer.this.container.properties.put(this.name, this.value);
            }
            HashContainer.this.save();
        }
    }
}

