/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.api;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.JavaLocator;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.jdkutils.JdkInstallationManager;
import net.covers1624.quack.collection.TypedMap;
import net.covers1624.quack.net.download.DownloadListener;
import net.covers1624.quack.net.download.DownloadProgressTail;
import net.covers1624.tconsole.api.Tail;
import net.covers1624.tconsole.api.TailConsole;
import net.covers1624.tconsole.api.TailGroup;
import net.covers1624.tconsole.tails.TextTail;
import net.covers1624.wt.api.dependency.DependencyLibrary;
import net.covers1624.wt.api.framework.FrameworkRegistry;
import net.covers1624.wt.api.gradle.GradleManager;
import net.covers1624.wt.api.gradle.GradleModelCache;
import net.covers1624.wt.api.mixin.MixinInstantiator;
import net.covers1624.wt.api.module.Module;
import net.covers1624.wt.api.script.ModdingFramework;
import net.covers1624.wt.api.script.WorkspaceScript;
import net.covers1624.wt.api.workspace.WorkspaceModule;
import net.covers1624.wt.api.workspace.WorkspaceRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkspaceToolContext {
    private static final Logger LOGGER = LogManager.getLogger();
    public TypedMap blackboard = new TypedMap();
    public Path projectDir;
    public Path cacheDir;
    public TailConsole console;
    public List<JavaInstall> javaInstalls;
    public JdkInstallationManager jdkManager;
    public FrameworkRegistry frameworkRegistry;
    public GradleManager gradleManager;
    public GradleModelCache modelCache;
    public WorkspaceRegistry workspaceRegistry;
    public MixinInstantiator mixinInstantiator;
    public WorkspaceScript workspaceScript;
    public DependencyLibrary dependencyLibrary;
    public List<Module> modules = new ArrayList<Module>();
    public List<Module> frameworkModules = new ArrayList<Module>();
    public List<WorkspaceModule> workspaceModules = new ArrayList<WorkspaceModule>();

    public Iterable<Module> getAllModules() {
        return Iterables.concat(this.frameworkModules, this.modules);
    }

    public boolean isFramework(Class<? extends ModdingFramework> framework) {
        return framework.equals(this.workspaceScript.getFrameworkClass());
    }

    public JavaInstall getJavaInstall(JavaVersion version) throws IOException {
        for (JavaInstall javaInstall : this.javaInstalls) {
            if (javaInstall.langVersion != version) continue;
            return javaInstall;
        }
        Path javaHome = this.jdkManager.findJdk(version, false);
        if (javaHome == null) {
            LOGGER.info("Unable to find compatible {} JDK. Provisioning..", (Object)version);
            TailGroup tailGroup = this.console.newGroupFirst();
            ((TextTail)tailGroup.add((Tail)new TextTail(1))).setLine(0, "===============================");
            DownloadProgressTail progress = new DownloadProgressTail();
            tailGroup.add((Tail)progress);
            javaHome = this.jdkManager.provisionJdk(version, false, (DownloadListener)progress);
            this.console.removeGroup(tailGroup);
        }
        return JavaLocator.parseInstall((Path)JavaInstall.getJavaExecutable((Path)javaHome, (boolean)false));
    }
}

