/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.event;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.covers1624.wt.event.Event;
import net.covers1624.wt.event.ResultEvent;

public class EventRegistry<E extends Event> {
    private final EventRegistry parent;
    private final Class<E> target;
    private final Listener<E>[][] listeners = new Listener[Event.Priority.values().length][0];

    public EventRegistry(Class<E> target) {
        this(null, target);
    }

    public EventRegistry(EventRegistry parent, Class<E> target) {
        this.parent = parent;
        this.target = target;
    }

    public HandlerKey register(Consumer<E> consumer) {
        return this.register(Event.Priority.NORMAL, consumer);
    }

    public HandlerKey register(Event.Priority priority, Consumer<E> consumer) {
        Listener<E> listener = new Listener<E>(consumer, priority, new HandlerKey());
        Listener<E>[] pListeners = this.listeners[priority.ordinal()];
        pListeners = Arrays.copyOf(pListeners, pListeners.length + 1);
        this.listeners[priority.ordinal()] = pListeners;
        pListeners[pListeners.length - 1] = listener;
        return listener.key;
    }

    public void unRegister(HandlerKey key) {
        Listener<E>[] listeners = this.listeners[key.listener.priority.ordinal()];
        int index = -1;
        for (int i = 0; i < listeners.length; ++i) {
            if (!listeners[i].key.equals(key)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("That key is not known to this EventRegistry.");
        }
        Listener<E>[] tmp = Arrays.copyOf(listeners, listeners.length);
        int n = listeners.length - index - 1;
        if (n > 0) {
            System.arraycopy(tmp, index + 1, tmp, index, n);
        }
        this.listeners[key.listener.priority.ordinal()] = Arrays.copyOf(tmp, tmp.length - 1);
    }

    public E fireEvent(E event) {
        for (Event.Priority priority : Event.Priority.values()) {
            this.fireInternal(event, priority);
        }
        return event;
    }

    private void fireInternal(E event, Event.Priority priority) {
        for (Listener<E> listener : this.listeners[priority.ordinal()]) {
            if (event instanceof ResultEvent) {
                ResultEvent rE = (ResultEvent)event;
                if (rE.hasResult() && rE.isGreedy()) {
                    listener.consumer.accept(event);
                    continue;
                }
                if (rE.hasResult()) continue;
                listener.consumer.accept(event);
                continue;
            }
            listener.consumer.accept(event);
        }
        if (this.parent != null) {
            this.parent.fireInternal(event, priority);
        }
    }

    private static class Listener<E> {
        final Consumer<E> consumer;
        final Event.Priority priority;
        final HandlerKey key;

        private Listener(Consumer<E> consumer, Event.Priority priority, HandlerKey key) {
            this.consumer = consumer;
            this.priority = priority;
            this.key = key;
            key.listener = this;
        }
    }

    public static final class HandlerKey {
        private static final AtomicInteger counter = new AtomicInteger();
        private final int inc = counter.getAndIncrement();
        Listener listener;

        private HandlerKey() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof HandlerKey) {
                return ((HandlerKey)obj).inc == this.inc;
            }
            return false;
        }
    }
}

