/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.util;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.covers1624.wt.util.HashContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitHelper {
    private static final Logger logger = LogManager.getLogger((String)"GitHelper");
    private static final String HASH_BRANCH_COMMIT = "branch-commit";
    private static final HashFunction sha256 = Hashing.sha256();
    private final HashContainer hashContainer;
    private String repoUrl;
    private Path path;
    private String branch;
    private String commit;
    private String branchSuffix;

    public GitHelper(HashContainer hashContainer) {
        this.hashContainer = hashContainer;
    }

    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setCommit(String commit) {
        this.commit = commit;
    }

    public void setBranchSuffix(String branchSuffix) {
        this.branchSuffix = branchSuffix;
    }

    public boolean validate() throws Throwable {
        Repository repo;
        Git git;
        String localBranchTarget = this.branch + this.branchSuffix;
        TextProgressMonitor pm = new TextProgressMonitor((Writer)new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        logger.info("Validating clone of '{}' ..", (Object)this.repoUrl);
        FileRepositoryBuilder builder = (FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.path.resolve(".git").toFile())).readEnvironment();
        Repository tmpRepo = builder.build();
        if (!tmpRepo.getObjectDatabase().exists()) {
            logger.info("Clone missing or corrupt, Re-Cloning..");
            CloneCommand clone = Git.cloneRepository();
            clone.setBare(false).setCloneAllBranches(true);
            clone.setDirectory(this.path.toFile());
            clone.setProgressMonitor((ProgressMonitor)pm);
            clone.setURI(this.repoUrl);
            git = clone.call();
            repo = git.getRepository();
        } else {
            repo = tmpRepo;
            git = new Git(repo);
        }
        String currentBranch = repo.getBranch();
        String currentCommit = repo.resolve("HEAD").name();
        Hasher branchHasher = sha256.newHasher();
        branchHasher.putString((CharSequence)this.branch, StandardCharsets.UTF_8);
        branchHasher.putString((CharSequence)this.commit, StandardCharsets.UTF_8);
        HashCode branchHash = branchHasher.hash();
        boolean correctBranch = currentBranch.equals(localBranchTarget);
        boolean correctCommit = currentCommit.startsWith(this.commit);
        boolean didStuff = false;
        if (this.hashContainer.check(HASH_BRANCH_COMMIT, branchHash) || !correctBranch || !correctCommit) {
            logger.info("Branch or Commit changed, Checking out new Branch / Commit..");
            git.fetch().setProgressMonitor((ProgressMonitor)pm).call();
            git.reset().setRef("HEAD").setMode(ResetCommand.ResetType.HARD).call();
            git.clean().setIgnore(false).setCleanDirectories(true).setForce(true).call();
            if (git.branchList().call().stream().noneMatch(e -> e.getName().equals("refs/heads/" + this.branch))) {
                git.checkout().setCreateBranch(true).setName(this.branch).setStartPoint("origin/" + this.branch).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).call();
            } else {
                git.checkout().setName(this.branch).call();
            }
            if (currentBranch.endsWith(this.branchSuffix)) {
                git.branchDelete().setBranchNames(new String[]{currentBranch}).setForce(true).call();
            }
            RevCommit checkout_start = repo.parseCommit((AnyObjectId)repo.resolve(this.commit));
            git.checkout().setStartPoint(checkout_start).setCreateBranch(true).setName(localBranchTarget).call();
            this.hashContainer.set(HASH_BRANCH_COMMIT, branchHash);
            logger.info("Checked out new Branch / Commit.");
            didStuff = true;
        }
        logger.info("Validated.");
        return didStuff;
    }
}

