/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.util.SneakyUtils;
import net.covers1624.wt.util.Utils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class JarRemapper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Remapper remapper;

    public JarRemapper(Remapper remapper) {
        this.remapper = remapper;
    }

    public void process(Path input, Path output) {
        if (Files.notExists(output, new LinkOption[0]) && Files.notExists(output.getParent(), new LinkOption[0])) {
            SneakyUtils.sneaky(() -> Files.createDirectories(output.getParent(), new FileAttribute[0]));
        }
        try (FileSystem inFs = IOUtils.getJarFileSystem((Path)input, (boolean)true);
             FileSystem outFs = IOUtils.getJarFileSystem((Path)output, (boolean)true);){
            Path inRoot = inFs.getPath("/", new String[0]);
            Path outRoot = outFs.getPath("/", new String[0]);
            Files.walkFileTree(inRoot, new Visitor(inRoot, outRoot, this.remapper));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Visitor
    extends SimpleFileVisitor<Path> {
        private final Path inRoot;
        private final Path outRoot;
        private final Remapper remapper;

        private Visitor(Path inRoot, Path outRoot, Remapper remapper) {
            this.inRoot = inRoot;
            this.outRoot = outRoot;
            this.remapper = remapper;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path outDir = this.outRoot.resolve(this.inRoot.relativize(dir).toString());
            if (Files.notExists(outDir, new LinkOption[0])) {
                Files.createDirectories(outDir, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path inFile, BasicFileAttributes attrs) throws IOException {
            block29: {
                Path outFile = this.outRoot.resolve(this.inRoot.relativize(inFile).toString());
                if (!(outFile.endsWith(".SF") || outFile.endsWith(".DSA") || outFile.endsWith(".RSA"))) {
                    if (outFile.toString().endsWith("META-INF/MANIFEST.MF")) {
                        try (InputStream is = Files.newInputStream(inFile, new OpenOption[0]);
                             OutputStream os = Files.newOutputStream(outFile, StandardOpenOption.CREATE);){
                            Manifest manifest = new Manifest(is);
                            manifest.getEntries().clear();
                            manifest.write(os);
                            os.flush();
                            break block29;
                        }
                    }
                    if (outFile.toString().endsWith(".class")) {
                        try (InputStream is = Files.newInputStream(inFile, new OpenOption[0]);
                             OutputStream os = Files.newOutputStream(outFile, StandardOpenOption.CREATE);){
                            ClassReader reader = new ClassReader(is);
                            ClassWriter writer = new ClassWriter(0);
                            ClassRemapper remapper = new ClassRemapper((ClassVisitor)writer, this.remapper);
                            reader.accept((ClassVisitor)remapper, 0);
                            os.write(writer.toByteArray());
                            os.flush();
                            break block29;
                        }
                    }
                    if (outFile.toString().endsWith(".refmap.json")) {
                        MixinRefMap refMap = Utils.fromJson(inFile, MixinRefMap.class);
                        refMap.mappings.values().forEach(this::transformRefMap);
                        refMap.data.values().forEach(e -> e.values().forEach(this::transformRefMap));
                        Utils.toJson((Object)refMap, MixinRefMap.class, outFile);
                    } else {
                        Files.copy(inFile, outFile, new CopyOption[0]);
                    }
                }
            }
            return FileVisitResult.CONTINUE;
        }

        private void transformRefMap(Map<String, String> mappings) {
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                String line;
                block6: {
                    line = entry.getValue();
                    try {
                        if (line.startsWith("L")) {
                            entry.setValue(this.remapTarget(line));
                            continue;
                        }
                        if (line.contains(":")) {
                            entry.setValue(this.remapField(line));
                            continue;
                        }
                        if (line.contains("(")) {
                            entry.setValue(this.remapMethod(line));
                        }
                        break block6;
                    }
                    catch (Throwable ex) {
                        LOGGER.error("Failed to remap line: '{}'", (Object)line, (Object)ex);
                    }
                    continue;
                }
                LOGGER.warn("Unknown entry in refmap json! '{}'", (Object)line);
            }
        }

        private String remapTarget(String target) {
            int firstSemiColon = target.indexOf(";");
            int descStart = target.indexOf("(");
            String owner = target.substring(1, firstSemiColon);
            String name = target.substring(firstSemiColon + 1, descStart);
            String desc = target.substring(descStart);
            String mappedOwner = this.remapper.mapType(owner);
            String mappedName = this.remapper.mapMethodName(owner, name, desc);
            String mappedDesc = this.remapper.mapMethodDesc(desc);
            return "L" + mappedOwner + ";" + mappedName + mappedDesc;
        }

        private String remapField(String field) {
            int colon = field.indexOf(58);
            String fName = field.substring(0, colon);
            String type = field.substring(colon + 1);
            return this.remapper.mapFieldName("", fName, "") + ":" + this.remapper.mapType(type);
        }

        private String remapMethod(String method) {
            int startDesc = method.indexOf(40);
            String mName = method.substring(0, startDesc);
            String desc = method.substring(startDesc);
            return this.remapper.mapMethodName("", mName, "") + this.remapper.mapMethodDesc(desc);
        }
    }

    private static class MixinRefMap {
        private final Map<String, Map<String, String>> mappings = new HashMap<String, Map<String, String>>();
        private final Map<String, Map<String, Map<String, String>>> data = new HashMap<String, Map<String, Map<String, String>>>();

        private MixinRefMap() {
        }
    }
}

