/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.util.tree;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.util.SneakyUtils;
import net.covers1624.wt.util.tree.TreeClassNode;
import net.covers1624.wt.util.tree.TreeFieldNode;
import net.covers1624.wt.util.tree.TreeMethodNode;
import net.covers1624.wt.util.tree.cache.CacheNode;
import net.covers1624.wt.util.tree.cache.ClassTreeCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;

public class ClassTree {
    private static final Logger logger = LogManager.getLogger((String)"ClassTree");
    private static final HashFunction sha256 = Hashing.sha256();
    private final Map<String, TreeClassNode> classMap = new HashMap<String, TreeClassNode>();
    private final Map<String, CacheNode> loadedClasses = new HashMap<String, CacheNode>();
    private ClassTreeCache classCache = new ClassTreeCache.NullClassTreeCache();

    public void setCache(ClassTreeCache cache) {
        this.classCache = cache;
    }

    public void loadClasses(Path path) {
        ((Stream)SneakyUtils.sneaky(() -> Files.walk(path, new FileVisitOption[0]))).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(e -> e.getFileName().toString().endsWith(".class")).forEach(file -> {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                this.loadClass(is);
            }
            catch (IOException e) {
                logger.warn("Failed to load class from: {}", file, (Object)e);
            }
        });
        this.classCache.save();
    }

    public void loadClass(InputStream is) {
        byte[] bytes = (byte[])SneakyUtils.sneaky(() -> IOUtils.toBytes((InputStream)is));
        ClassReader reader = new ClassReader(bytes);
        String className = reader.getClassName();
        HashCode hashCode = sha256.hashBytes(bytes);
        CacheNode cacheNode = this.classCache.getNode(className);
        CacheNode loadedNode = this.loadedClasses.get(className);
        if (loadedNode != null && !loadedNode.check(hashCode, bytes.length)) {
            logger.warn("Attempted to load Duplicate classes with differing hashes, Skipping.. Class: {}", (Object)className);
            return;
        }
        this.loadedClasses.put(className, cacheNode);
        if (cacheNode != null && cacheNode.check(hashCode, bytes.length)) {
            TreeClassNode node = cacheNode.getNode();
            this.getClassNode(className).copyFrom(node);
            return;
        }
        TreeClassNode node = this.getClassNode(className);
        reader.accept(node.visitClass(), 0);
        this.classCache.update(node, hashCode, bytes.length);
    }

    public TreeClassNode getClassNode(String name) {
        return this.classMap.computeIfAbsent(name, e -> {
            TreeClassNode node = new TreeClassNode(this);
            node.name = name;
            return node;
        });
    }

    public Map<String, TreeClassNode> getClassMap() {
        return this.classMap;
    }

    public TreeFieldNode createFieldNode(String name) {
        TreeFieldNode node = new TreeFieldNode(this);
        node.name = name;
        return node;
    }

    public TreeMethodNode createMethodNode(String name, String desc) {
        TreeMethodNode node = new TreeMethodNode(this);
        node.name = name;
        node.desc = desc;
        return node;
    }
}

