/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.util.tree.cache;

import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.covers1624.wt.util.Utils;
import net.covers1624.wt.util.tree.TreeClassNode;
import net.covers1624.wt.util.tree.cache.CacheNode;
import net.covers1624.wt.util.tree.cache.ClassTreeCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassTreeCacheImpl
implements ClassTreeCache,
Serializable {
    private static final Logger logger = LogManager.getLogger((String)"ClassTreeCache");
    private final Map<String, CacheNodeImpl> hashCache = new HashMap<String, CacheNodeImpl>();
    private transient Path path;
    private transient boolean dirty;

    private ClassTreeCacheImpl() {
        this(null);
    }

    public ClassTreeCacheImpl(Path path) {
        this.path = path;
    }

    @Override
    public CacheNode getNode(String className) {
        return this.hashCache.get(className);
    }

    @Override
    public void update(TreeClassNode node, HashCode hash, int contentLength) {
        this.dirty = true;
        this.hashCache.put(node.name, new CacheNodeImpl(node, hash, contentLength));
    }

    @Override
    public void save() {
        if (this.dirty) {
            this.dirty = false;
            try (ObjectOutputStream os = new ObjectOutputStream(Files.newOutputStream(Utils.makeFile(this.path), new OpenOption[0]));){
                os.writeObject(this);
            }
            catch (IOException e) {
                logger.warn("Failed to save ClassTreeCache to file: {}", (Object)this.path, (Object)e);
            }
        }
    }

    public static ClassTreeCache from(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            ClassTreeCacheImpl classTreeCacheImpl;
            ObjectInputStream is = new ObjectInputStream(Files.newInputStream(path, new OpenOption[0]));
            try {
                ClassTreeCacheImpl cache = (ClassTreeCacheImpl)is.readObject();
                cache.path = path;
                classTreeCacheImpl = cache;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | ClassNotFoundException e) {
                    logger.warn("Failed to load ClassTreeCache from path: {}", (Object)path, (Object)e);
                }
            }
            is.close();
            return classTreeCacheImpl;
        }
        ClassTreeCacheImpl cache = new ClassTreeCacheImpl(path);
        cache.dirty = true;
        return cache;
    }

    private class CacheNodeImpl
    implements Serializable,
    CacheNode {
        public TreeClassNode node;
        public String className;
        public HashCode hashCode;
        public int contentLength;

        public CacheNodeImpl(TreeClassNode node, HashCode hashCode, int contentLength) {
            this.node = node;
            this.className = node.name;
            this.hashCode = hashCode;
            this.contentLength = contentLength;
        }

        @Override
        public TreeClassNode getNode() {
            return this.node;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public HashCode getHashCode() {
            return this.hashCode;
        }

        @Override
        public int getContentLength() {
            return this.contentLength;
        }

        @Override
        public boolean check(HashCode hashCode, int contentLength) {
            return this.hashCode.equals((Object)hashCode) && this.contentLength == contentLength;
        }
    }
}

