/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.wt.event;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.covers1624.quack.util.HashUtils;
import net.covers1624.wt.api.event.VersionedClass;
import net.covers1624.wt.event.Event;
import net.covers1624.wt.event.EventRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleHashCheckEvent
extends Event {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final EventRegistry<ModuleHashCheckEvent> REGISTRY = new EventRegistry<ModuleHashCheckEvent>(ModuleHashCheckEvent.class);
    private static final ClassVersionCache classVersionCache = new ClassVersionCache();
    private static final HashFunction sha256 = Hashing.sha256();
    private final Path modulePath;
    private final Map<String, HashCode> extraHashes = new HashMap<String, HashCode>();

    public ModuleHashCheckEvent(Path modulePath) {
        this.modulePath = modulePath;
    }

    public Path getModulePath() {
        return this.modulePath;
    }

    public Map<String, HashCode> getExtraHashes() {
        return this.extraHashes;
    }

    public void putHashCode(String key, HashCode v) {
        this.extraHashes.put(key, v);
    }

    public void putByte(String key, byte v) {
        this.extraHashes.put(key, sha256.newHasher().putByte(v).hash());
    }

    public void putBytes(String key, byte[] bytes) {
        this.extraHashes.put(key, sha256.newHasher().putBytes(bytes).hash());
    }

    public void putBytes(String key, byte[] bytes, int off, int len) {
        this.extraHashes.put(key, sha256.newHasher().putBytes(bytes, off, len).hash());
    }

    public void putBytes(String key, ByteBuffer bytes) {
        this.extraHashes.put(key, sha256.newHasher().putBytes(bytes).hash());
    }

    public void putChar(String key, char v) {
        this.extraHashes.put(key, sha256.newHasher().putChar(v).hash());
    }

    public void putShort(String key, short v) {
        this.extraHashes.put(key, sha256.newHasher().putShort(v).hash());
    }

    public void putInt(String key, int v) {
        this.extraHashes.put(key, sha256.newHasher().putInt(v).hash());
    }

    public void putFloat(String key, float v) {
        this.extraHashes.put(key, sha256.newHasher().putFloat(v).hash());
    }

    public void putLong(String key, long v) {
        this.extraHashes.put(key, sha256.newHasher().putLong(v).hash());
    }

    public void putDouble(String key, double v) {
        this.extraHashes.put(key, sha256.newHasher().putDouble(v).hash());
    }

    public void putBoolean(String key, boolean v) {
        this.extraHashes.put(key, sha256.newHasher().putBoolean(v).hash());
    }

    public void putUnencodedChars(String key, CharSequence v) {
        this.extraHashes.put(key, sha256.newHasher().putUnencodedChars(v).hash());
    }

    public void putString(String key, CharSequence v) {
        this.extraHashes.put(key, sha256.newHasher().putString(v, StandardCharsets.UTF_8).hash());
    }

    public void putString(String key, CharSequence v, Charset charset) {
        this.extraHashes.put(key, sha256.newHasher().putString(v, charset).hash());
    }

    public void putVersionedClass(Class<?> clazz) {
        classVersionCache.lookup(clazz).addToEvent(this);
    }

    public void putClassBytes(String cName) {
        try (InputStream is = ModuleHashCheckEvent.class.getResourceAsStream("/" + cName.replace(".", "/") + ".class");){
            Hasher hasher = sha256.newHasher();
            HashUtils.addToHasher((Hasher)hasher, (InputStream)is);
            this.extraHashes.put(cName, hasher.hash());
        }
        catch (IOException e) {
            LOGGER.error("Unable to get bytes of class {}", (Object)cName, (Object)e);
        }
    }

    private static class ClassVersionCache {
        private final Map<Class<?>, CachedClass> classCache = new HashMap();

        private ClassVersionCache() {
        }

        public CachedClass lookup(Class<?> clazz) {
            CachedClass existing = this.classCache.get(clazz);
            if (existing == null) {
                existing = new CachedClass(clazz);
                this.classCache.put(clazz, existing);
            }
            return existing;
        }

        public class CachedClass {
            public final Class<?> clazz;
            public boolean hasVersionedClass;
            public int versionedClassValue;
            public ObjectStreamClass osc;
            public CachedClass superClass;
            public List<CachedClass> interfaces = new ArrayList<CachedClass>();

            public CachedClass(Class<?> clazz) {
                this.clazz = clazz;
                if (clazz.isAnnotationPresent(VersionedClass.class)) {
                    this.hasVersionedClass = true;
                    this.versionedClassValue = clazz.getAnnotation(VersionedClass.class).value();
                }
                this.osc = ObjectStreamClass.lookup(clazz);
                if (clazz.getSuperclass() != null && !Object.class.equals(clazz.getSuperclass())) {
                    this.superClass = ClassVersionCache.this.lookup(clazz.getSuperclass());
                }
                for (Class<?> iFace : clazz.getInterfaces()) {
                    this.interfaces.add(ClassVersionCache.this.lookup(iFace));
                }
            }

            public void addToEvent(ModuleHashCheckEvent event) {
                if (this.hasVersionedClass) {
                    event.putInt("extracted_version:" + this.clazz.getName(), this.versionedClassValue);
                }
                if (this.osc != null) {
                    event.putLong("serialVersionId:" + this.clazz.getName(), this.osc.getSerialVersionUID());
                }
                if (this.superClass != null) {
                    this.superClass.addToEvent(event);
                }
                this.interfaces.forEach(e -> e.addToEvent(event));
            }
        }
    }
}

